function project_mgr_output_history(fig)
% output parameter list by text file
% [USAGE]
%    project_mgr_output_history(<fig>);
% [IN]
%    fig : figure handle of proeject_mgr gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

h = file_dialog;
project_root = get(H.project_root_edit, 'String');
h = set(h, 'current_dir', project_root);
h = set(h, 'file_extensions', {'.txt'});
h = set(h, 'save_mode', 1);

% get text filename
history_file = [];
[dir_name, fnames] = visible(h);
if ~isempty(dir_name) && ~isempty(fnames{1})
    history_file = [dir_name, filesep, fnames{1}];
else
    return;
end

% get all parameters
[all_parms, parm_types] = project_file_mgr('get_all_parameters');
Nparm = length(all_parms);

% output text file
fid = fopen(history_file, 'w');
if fid == -1, return; end;
for k=1:Nparm
    parm_str = vb_struct2str(all_parms{k});
    fprintf(fid, '------------------------------------\n');
    fprintf(fid, '%s (%s)\n', parm_types{k}, all_parms{k}.time_stamp);
    fprintf(fid, '------------------------------------\n');
    for j=1:length(parm_str)
        if findstr('time_stamp', parm_str{j})
            continue;
        else
            fprintf(fid, '%s\n', parm_str{j});
        end
    end
    fprintf(fid, '\n\n');
end
fclose(fid);
