function [ix] = project_mgr_get_ix_for_check_model(fig, parm_type)
% get index for check model
% [USAGE]
%    ix = project_mgr_set_ix_for_check_model(<fig>, <parm_type>);
% [IN]
%          fig : figure handle of project_mgr gui.
%    parm_type : 'brain_parm' or 'fmri_parm' or 'meg_parm' (char array)
% [OUT]
%    ix : selected line number of parameter list.   (scalar)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see project_mgr_init_ix_for_check_model)
data = guidata(fig);

switch(parm_type)
    case 'brain_parm'
        ix = data.parm_ix_for_check_model(1);
    case 'fmri_parm'
        ix = data.parm_ix_for_check_model(2);
    case 'meg_parm'
        ix = data.parm_ix_for_check_model(3);
    otherwise
        error('invalid parm_type is specified.');
end

