function project_mgr_contextmenu_open(data, show_context_menu)
% open context menu by right click.
% [USAGE]
%    project_mgr_contextmenu_open(data[,show_context_menu]);
% [IN]
%                 data : project_mgr data
%    show_context_menu : show context menu
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('show_context_menu', 'var')
    show_context_menu = true;
end

%
% --- Main Procedure
%
H = data.H; % component handles

% get history listbox selected line
selected_line_no = get(H.history_listbox, 'Value');
max_line_no = length(get(H.history_listbox, 'String'));

% default : all menues are not enable.
uimenues = get(H.history_context_menu, 'Children');
set(uimenues, 'Visible', 'off');

% project is not loaded.
if max_line_no == 0
    set(H.history_context_menu, 'Visible', 'off');
    return;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set menu for each parameter type
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% "open" and "Export as M-file" is always enable.
set(H.submenu_launch_application, 'Visible', 'on');
set(H.submenu_export_script,      'Visible', 'on');

% enable menu for each parameter type
[parm, parm_type] = project_file_mgr('get_parameter', selected_line_no);
func_type = vb_judge_function_name(parm, parm_type);

switch(func_type)
    case {'vb_job_brain'}
        set(H.submenu_job_view_cortex, 'Visible', 'on');
        set(H.submenu_job_edit_area, 'Visible', 'on');
        set(H.submenu_job_edit_act, 'Visible', 'on');
%        set(H.submenu_job_select_area, 'Visible', 'on');
    case {'vb_job_fmri'}
        set(H.submenu_job_view_cortex, 'Visible', 'on');
        set(H.submenu_job_edit_area, 'Visible', 'on');
        set(H.submenu_job_edit_act, 'Visible', 'on');
%        set(H.submenu_job_select_area, 'Visible', 'on');
    case {'vb_job_meg'}
        set(H.submenu_job_plot_meg, 'Visible', 'on');
    case {'vb_job_head_3shell'}
        set(H.submenu_view_head, 'Visible', 'on');
    case {'vb_job_current'}
        set(H.submenu_job_plot_currentmap, 'Visible', 'on');
end

org_units = get(H.history_listbox, 'Units');
set(H.history_listbox, 'Units', 'pixels');
Pos = get(H.history_listbox, 'Position');
set(H.history_listbox, 'Units', org_units);

pos = [Pos(1)+Pos(3), Pos(2)+Pos(4)];
set(H.history_context_menu, 'Position', pos);

current_figure = get(0, 'CurrentFigure');
if ~isempty(current_figure) && ...
    ishandle(current_figure) && ...
    current_figure == data.H.figure
    if show_context_menu
        set(H.history_context_menu, 'Visible', 'on');
    else
        set(H.history_context_menu, 'Visible', 'off');
    end
end
drawnow;
