function project_mgr_close(fig)
% close project_mgr gui and module guis.
% [USAGE]
%    project_mgr_close(<fig>);
% [IN]
%    fig : figure handle of project_mgr gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.'); 
end

%
% --- Main Procedure
%

% load data (@see project_mgr)
data = guidata(fig);

% brain figure close
figures = inner_get_valid_handle(data.pa_brain_fig);
if ~isempty(figures)
    for k=1:length(figures)
        pa_brain_close(figures(k));
    end
end

% fmri figure close
figures = inner_get_valid_handle(data.pa_fmri_fig);
if ~isempty(figures)
    for k=1:length(figures)
        pa_fmri_close(figures(k));
    end
end

% biosemi eeg figure close
figures = inner_get_valid_handle(data.pa_biosemi_eeg_fig);
if ~isempty(figures)
    for k=1:length(figures)
        pa_biosemi_eeg_close(figures(k));
    end
end

% brainamp eeg figure close
figures = inner_get_valid_handle(data.pa_brainamp_eeg_fig);
if ~isempty(figures)
    for k=1:length(figures)
        pa_brainamp_eeg_close(figures(k));
    end
end

% yokogawa meg figure close
figures = inner_get_valid_handle(data.pa_yokogawa_meg_fig);
if ~isempty(figures)
    for k=1:length(figures)
        pa_yokogawa_meg_close(figures(k));
    end
end

% sbi meg figure close
figures = inner_get_valid_handle(data.pa_sbi_meg_fig);
if ~isempty(figures)
    for k=1:length(figures)
        pa_sbi_meg_close(figures(k));
    end
end

% leadfield figures close
figures = inner_get_valid_handle(data.pa_leadfield_fig);
if ~isempty(figures)
    for k=1:length(figures)
        pa_leadfield_close(figures(k));
    end
end

% bayes figures close
figures = inner_get_valid_handle(data.bayes_fig);
if ~isempty(figures)
    for k=1:length(figures)
        bayes_parm_editor(figures(k), 'finish_request');
    end
end

% Head figures close
figures = inner_get_valid_handle(data.pa_head_fig);
if ~isempty(figures)
    for k=1:length(figures)
        pa_head_close(figures(k));
    end
end

% Current figures close
figures = inner_get_valid_handle(data.current_fig);
if ~isempty(figures)
    for k=1:length(figures)
        current_gui_delete(figures(k));
    end
end

% Tools figures close
figures = inner_get_valid_handle(data.tools_fig);
if ~isempty(figures)
    for k=1:length(figures)
        set(0, 'CurrentFigure', figures(k));
        tool_launcher('exit');
    end
end

% Batch builder close
figures = inner_get_valid_handle(data.batch_fig);
if ~isempty(figures)
    for k=1:length(figures)
        delete(figures(k));
    end
end

% project mgr figure close
delete(fig);

function [handles] = inner_get_valid_handle(handles)
% check and return valid figure handles
% [USAGE]
%    handles = inner_get_valid_handle(<handles>);
% [IN]
%    handles : figure handles
% [OUT]
%    handles : valid handles

% remove empty entry
empty_ix = isempty(handles);
if isempty(empty_ix)
    handles(empty_ix) = [];
end

% extract valid handle list
valid_ix = find(ishandle(handles) == 1);
handles = handles(valid_ix, :);
