function project_mgr(flag)
% create project_mgr gui.
% [USAGE]
%    fig = project_mgr;
% [IN]
%    flag : atr flag. (default:false)
% [OUT]
%    fig : figure handle of project_mgr gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('flag', 'var') || isempty(flag)
    flag = false;
else
    flag = true;
end

%
% --- Main Procedure
%
hidden_state = get(0, 'ShowHiddenHandles');

% all figure handles visible
set(0, 'ShowHiddenHandles', 'on');
fig = findobj('Tag', 'project_mgr');
% figure handles visible state rollback
set(0, 'ShowHiddenHandles', hidden_state);

if isempty(fig)
    fig = openfig('project_mgr.fig');
    set(fig, 'HandleVisibility', 'callback');
else
    figure(fig);
    return;
end

H = guihandles(fig);
H.figure = fig;

data = struct;
data.H = H;
data.flag = flag; % for atr mode
data.project_file = '';

% handles of Data Import and Analysis gui.
% -- ishandle([]) doesn't return false. 
%    because -1 specified.
data.pa_brain_fig        = [];
data.pa_fmri_fig         = [];
data.pa_biosemi_eeg_fig  = [];
data.pa_brainamp_eeg_fig = [];
data.pa_yokogawa_meg_fig = [];
data.pa_sbi_meg_fig      = [];
data.pa_yokogawa_meg_fig = [];
data.pa_head_fig         = [];
data.pa_leadfield_fig    = [];
data.bayes_fig           = [];
data.current_fig         = [];

% handles of Tools
data.tools_fig = [];

% handles of batch builder
data.batch_fig = [];
data.batch_builders = cell(0);

% save data
guidata(fig, data);

% make member for check model.
project_mgr_init_ix_for_check_model(fig);

% tmp/vbmeg-username/project_file_loaded.mat
uname = vb_get_username;
uname = strrep(uname, ' ', '');

last_open = [tempdir, 'vbmeg-', uname, '/project_file_loaded.mat'];
if exist(last_open, 'file') == 2
    load(last_open, 'project_file');
    project_mgr_load_project_file(project_file, data, fig);
end
