function pa_yokogawa_meg_edit_extra_channel_gain(fig)
% Edit and save extra channel gain.
% [USAGE]
%    pa_yokogawa_meg_edit_extra_channel_gain(<fig>);
% [IN]
%    fig : figure handle of yokogawa meg gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%

% load data(@see pa_yokogawa_meg_create)
data = guidata(fig);
H = data.H;


%
% --- read extra channel info from Yokogawa MEG file.
%
meg_file = get(H.meg_file_edit, 'String');
if exist(meg_file, 'file') ~= 2
    errordlg('Cannot open MEG file.', 'error');
    return;
end
% load extra channel name definition and init gain value
ex_all_name = vb_ykgwfile_load_channel_name_extra(meg_file, []);
ex_all_gain = zeros(length(ex_all_name), 1);
if isempty(ex_all_name)
    errordlg('Extra channel definition cannot be found in MEG file.');
    return;
end

% Set current inputted gain value into ex_all_gain.
ex_ch_gain = data.yokogawa_meg_parm.ex_ch_gain;
if ~isempty(ex_ch_gain)
    % channel name & previous inputted gain value
    inputted_ch_list = {ex_ch_gain.name};
    for k=1:length(inputted_ch_list)
        ix = strmatch(inputted_ch_list{k}, ex_all_name);
        ex_all_gain(ix) = ex_ch_gain(k).value;
    end
end

% edit gain value
[editted_gain, cancelled] = gain_input('init', ex_all_name, ex_all_gain);

if cancelled || isempty(editted_gain), return; end

ret_ch_name  = editted_gain(:, 1);
ret_gain     = editted_gain(:, 2);

%
% --- make extra_gain array(This format is defined meg_parm.extra_gain)
%
ex_ch_gain = [];
for k=1:length(ret_ch_name)
    ex_ch_gain = [ex_ch_gain; ...
                  struct('name', ret_ch_name{k}, 'value', ret_gain{k})];
end

% set local meg_parm
data.yokogawa_meg_parm.ex_ch_gain = ex_ch_gain;

set(H.gain_setting_text, 'String', 'Specified');

% save data
guidata(fig, data);
