function vb_timeseries_viewer_slider_event(varargin)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

fig  = getappdata(gcbo, 'Figure');
obj = guidata(fig);

hObj = findobj(fig, 'Tag', get(gcbo, 'Tag'));
setappdata(hObj, 'dragging', true);

% slider callback is realized by using MATLAB hack.
% So, gcf function doesn't work in the callback function.
% Then, I change ShowHiddenHandles turn on and after calling callback
% function, and revert it immediately.
current = get(0, 'ShowHiddenHandles');
set(0, 'ShowHiddenHandles', 'on');
set(0, 'CurrentFigure', obj.figure);
vb_timeseries_viewer_callback(obj, hObj);
set(0, 'ShowHiddenHandles', current);

% not to crash when figure is closed while running plotting.
if ~ishandle(hObj), return; end

setappdata(hObj, 'dragging', false);

