function [obj] = vb_timeseries_viewer_plot_measurement_data(obj, window_from, window_to)
% plot measurement data
% [USAGE]
%    [obj] = vb_timeseries_viewer_plot_measurement_data(obj, window_from, window_to);
% [IN]
%            obj : vb_timeseries_viewer object.
%    window_from : display from [sec] 
%      window_to : display to   [sec]
% [OUT]
%    obj : vb_timeseries_viewer object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%

H = obj.H;

% Remove previous legend
if isfield(obj, 'ext_legend_handle')
    try
    delete(obj.rejected_channel_legend);
    catch
    end
end

cla(H.data_axes);
if ~isempty(obj.meg_obj) && ~isempty(obj.data_ch_list_plot_ix)
    Nsample = vb_continuous_file_get_Nsample(obj.meg_obj);
    freq    = vb_continuous_file_get_sample_freq(obj.meg_obj);

    [obj.meg_obj, data, from, to, ch_name, ch_active] = ...
            vb_continuous_file_get_sample(obj.meg_obj, ...
                  obj.data_ch_list(obj.data_ch_list_plot_ix), ...
                  ceil(freq*window_from), ceil(freq*window_to));
    axis(H.data_axes, 'manual');
    step = 1;
    t  = [from-1:to-1]/freq;
    ix = [1:step:size(data,2)];

    % Acitve/Inactive channel
    ch_active_ix   = find(ch_active == true);
    ch_inactive_ix = find(ch_active == false);

    % Active channel
    h1 = []; h2 = [];
    if ~isempty(ch_active_ix)
        h1 = plot(H.data_axes, t(1:step:length(t)), data(ch_active_ix, ix), 'k');
    end
    
    % Prepare to show Inactive channel(legend)
    if ~isempty(ch_inactive_ix)
        hold(H.data_axes, 'on');
        i_ch = '';
        for k=1:length(ch_inactive_ix)
            i_ch = [' ', i_ch, ch_name{ch_inactive_ix(k)}, ','];
            % remove last character
            if k==length(ch_inactive_ix)
                i_ch(end) = '';
            end
        end
        h2 = plot(H.data_axes, t(1:step:length(t)), data(ch_inactive_ix, ix), 'g');
        obj.rejected_channel_legend = legend(h2(end), ['Inactive channel:' i_ch]);
        set(obj.rejected_channel_legend, 'FontSize', 10.5, 'FontUnit', 'points');
    end

    set(H.unavailable_text, 'Visible', 'off');
    set(H.make_preview_file_push, 'Visible', 'off');
else
end

% Set Grid on
set(H.data_axes, 'XGrid', 'on');
set(H.data_axes, 'YGrid', 'on');

% position
xlim(H.data_axes,    [window_from, window_to]);
