function [brief_info] = vb_trigger_get_brief_str(obj)
% get trigger information
% [USAGE]
%    brief_info = vb_trigger_get_brief_str(obj);
% [IN]
%    obj : trigger object.
% [OUT]
%    brief_info : brief information of trigger.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%

brief_info = ['[' obj.trig_type ']', 'Ch'];

for k=1:length(obj.status_ch)
    brief_info = [brief_info, obj.status_ch{k} ':'];
end

switch(obj.trig_type)
    case 'analog'
        brief_info = [brief_info, 'level(', num2str(obj.status_level), ')', ...
                      ':slope(', obj.slope, ')'];
    case 'emg'
        brief_info = [brief_info, 't_event(', num2str(obj.t_event), ')', ...
                      ':t_period(', num2str(obj.t_period), ')', ...
                      ':p_val(', num2str(obj.p_val), ')'];
    case 'voice'
        brief_info = [brief_info, 't_period(', num2str(obj.t_period), ')', ...
                      ':status_level(', num2str(obj.status_level), ')'];
    case 'integer'
        brief_info = [brief_info,  'bitpattern(' dec2bin(obj.status_level), ')', ...
                      ':slope(', obj.slope, ')', ...
                      ':bitmask(' obj.status_mask, ')', ...
                      ':offset(', num2str(obj.status_offset) ')'];
    case 'bit'
        brief_info = [brief_info, 'bitnumber(' num2str(log2(obj.status_level)) ')', ...
                      ':slope(', obj.slope, ')'...
                      ':bitmask(' obj.status_mask, ')', ...
                      ':offset(', num2str(obj.status_offset) ')'];
    case 'multi'
        brief_info = [brief_info, 'pattern(' ...
                          strrep(num2str(obj.status_level), ' ', ''), ')', ...
                      ':slope(', obj.slope, ')'...
                      ];
end
