function [new_tag] = vb_tag_util_union_tag(tags, new_name, trial_list)
% Create new tag from multiple tags.
% trial index are sorted by time.
% [IN]
%          tags : tag object list [1xN], [Nx1]
%      new_name : new tag name.
%    trial_list : trial object list.
% [OUT]
%    new_tag : new tag object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('tags', 'var')
    error('tag list are required.');
end
if ~exist('new_name', 'var')
    error('new_name is a required parameter.');
end
if ~exist('trial_list', 'var')
    error('trial_list is a required parameter.');
end

%
% --- Main Procedure
%
Ntags = length(tags);
tags_trial_ix = [];
for k=1:Ntags
    tags_trial_ix = [tags_trial_ix; ...
                     vb_tag_get_trial_index(tags(k))];
end

tags_trial_ix = unique(tags_trial_ix);
trial_set     = trial_list(tags_trial_ix);
Ntrial = length(trial_set);

new_tag = vb_tag_new(new_name);

% Create new tag
if Ntrial
    % Sort by 'from'
    [tmp, time_ix] = sort([trial_set.from]);

    % Sort trial index
    new_trial_ix = tags_trial_ix(time_ix);
    new_tag = vb_tag_add_trial_index(new_tag, new_trial_ix);
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive new tag object.');
end

