function [tag_obj] = vb_tag_new(tag_name)
% tag for classifying trial
%
% [USAGE]
%    [tag_obj] = vb_tag_new(tag_name);
% [IN]
%    tag_name : tag name [string]
% [OUT]
%    tag_obj : tag object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('tag_name', 'var')
    error('tag_name is a required parameter.');
end
if ~ischar(tag_name)
    error('tag name should be string.');
end

%
% --- Main Procedure
%
tag_obj = struct;
tag_obj.name = tag_name;
tag_obj.trial_ix = [];

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive tag_obj.');
end
