function [obj] = vb_emg_trigger_new(ch_name, status_level, ...
                                   t_event, t_smooth, t_period, p_val)
% Create emg trigger.
%
% [USAGE]
%    vb_emg_trigger_new(ch_name, t_event, t_smooth, t_period, p_val)
% [IN]
%         ch_name : extract trigger from this channel [string]
%    status_level : 
%         t_event : <optional>
%        t_smooth : <optional>
%        t_period : <optional>
%           p_val : <optional>
% [OUT]
%           obj : emg_trigger object
% [see also]
%    vb_get_voice_onset
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin < 1
    error('This function needs 1 argments. Please check your code.');
end

%
% --- Main Procedure
%
obj = vb_trigger_new(ch_name, 'emg', status_level);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PARAMETER NAME IS IMPORTANT(for vb_get_trial_index)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if exist('t_event', 'var')
    obj.t_event = t_event;
end
if exist('t_smooth', 'var')
    obj.t_smooth = t_smooth;
end
if exist('t_period', 'var')
    obj.t_period = t_period;
end
if exist('p_val', 'var')
    obj.p_val    = p_val;
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
