function [obj, ch_data, from, to, ch_name, ch_active] = vb_continuous_file_get_sample(obj, ch_list, from, to)
% return specified channel data.
% [USAGE]
%    [obj, ch_data] = vb_continuous_file_get_sample(obj, ch_list, from, to);
% [IN]
%        obj : continuous file object.
%    ch_list : channel name list to get data {Nx1}
%       from : get from this sample number.
%         to : get data 'from' to 'to' .
% [OUT]
%        obj : continuous file object.
%    ch_data : specified channel data
%       from : got from this sample number.
%         to : got data until this sample number.
%    ch_name : read channel name
%  ch_active : flag list of channel are active or not.
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ischar(ch_list)
    ch_list = {ch_list};
end
if isempty(ch_list)
    ch_list = cell(0);
end
if ~iscellstr(ch_list)
    error('ch_list should be cell string.');
end
if ~exist('from', 'var')
    error('from is a required parameter.');
end
if ~exist('to', 'var')
    error('to is a required parameter.');
end

if ~isfield(obj, 'cache_data')
    obj.cache_data = struct;
end
if ~isfield(obj.cache_data, 'sample_list')
    obj.cache_data.sample_list = [];
end
if ~isfield(obj.cache_data, 'data')
    obj.cache_data.data = [];
end
if ~isfield(obj.cache_data, 'Name')
    obj.cache_data.Name = [];
end

%
% --- Main Procedure
%
Nsample = vb_continuous_file_get_Nsample(obj);
if from <= 0
    from = 1;
end
if to > Nsample
    to = Nsample;
end

freq = vb_continuous_file_get_sample_freq(obj);


cix_from = [];
cix_to   = [];
ch_name  = [];

if ~isempty(obj.cache_data.sample_list)
    cix_from = find(obj.cache_data.sample_list == from);
    cix_to   = find(obj.cache_data.sample_list == to);
end

if isempty(cix_from) || isempty(cix_to)
    % miss hit
    MARGIN = ceil(freq * 10); % margin pre-post data
    if from-MARGIN < 0
        read_from = 1;
    else
        read_from = from-MARGIN;
    end
    if to + MARGIN > Nsample
        read_to = Nsample;
    else
        read_to = to + MARGIN;
    end
    read_len = read_to - read_from + 1;

    % load data
    if ~isempty(obj.read_ch_list)
        load_spec.ChannelName = obj.read_ch_list;
        load_spec.ActiveChannel = false; % all the channels including inactive
        load_spec.Pretrigger  = 0;
        load_spec.Trigger     = read_from;
        load_spec.Posttrigger = read_to - read_from;
        warning('OFF', 'MATLAB:hg:uicontrol:ParameterValuesMustBeValid');
        h = msgbox('Now reading data...', 'Please wait');
        bh = findall(h, 'Style', 'pushbutton');
        set(bh, 'Visible', 'off', 'Enable', 'off');
        drawnow; pause(0.1);
        warning('ON', 'MATLAB:hg:uicontrol:ParameterValuesMustBeValid');

        [obj.cache_data.data, ch_info] = vb_load_meg_data(obj.filename, load_spec);
        if isfield(ch_info, 'Name')
            obj.cache_data.Name    = ch_info.Name;
            obj.cache_data.hashkey = struct;
            obj.cache_data.active  = ch_info.Active;
            for j=1:length(ch_info.Name)
                % fieldname is used as a hash key for speeding
                hashkey = ['hash_' vb_CalcMD5(ch_info.Name{j}, 'char')];
                obj.cache_data.hashkey.(hashkey) = j;
            end
        end
        if ishandle(h), delete(h); end
        obj.cache_data.sample_list = [read_from:read_to];
    end
end

data_ix = [];
for k=1:length(ch_list)
    hashkey = ['hash_' vb_CalcMD5(ch_list{k}, 'char')];
    if isfield(obj.cache_data.hashkey, hashkey)
        data_ix = [data_ix; obj.cache_data.hashkey.(hashkey)];
    end
end
% return data
cix_from = find(obj.cache_data.sample_list == from);
cix_to   = find(obj.cache_data.sample_list == to);
if ~isempty(obj.cache_data.data)
    ch_data   = obj.cache_data.data(data_ix, cix_from:cix_to);
    ch_name   = obj.cache_data.Name(data_ix);
    ch_active = obj.cache_data.active(data_ix);
else
    ch_data   = [];
    ch_name   = [];
    ch_active = [];
end

from = obj.cache_data.sample_list(cix_from);
to   = obj.cache_data.sample_list(cix_to);

% % debug
% if size(obj.cache_data.sample_list, 2) ~= 1787500
%     dbstack;
%     a = 1;
% end



%
% --- After check
%
if nargout < 1
    error('function caller should receive return values');
end

    