function [selected_ch_list, cancel] = vb_te_channel_selector_new(all_ch_list, selected_ch_list, caption)

%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

h = openfig('vb_te_channel_selector.fig');
if exist('caption', 'var')
    set(h, 'Name', caption);
end
H = guihandles(h);

cancel = false;

data = struct;
data.H = H;
data.cancel_flag = false;
guidata(h, data);

% Dummy data for test
if ~exist('all_ch_list', 'var')
    for k=1:400
        all_ch_list{k} = num2str(k);
    end
end

if ~exist('selected_ch_list', 'var')
    i=1;
    for k=1:8:400
        selected_ch_list{i} = num2str(k);
        i = i+1;
    end
end

% Create table
table = cell(0);
title = {'Channel', 'ON/OFF'};
for k=1:length(all_ch_list)
    ix = strmatch(all_ch_list{k}, selected_ch_list, 'exact');
    flag = false;
    if ~isempty(ix)
        flag = true;
    end
    table{k, 1} = all_ch_list{k};
    table{k, 2} = flag;
end
if vb_matlab_version('>=', '7.6')
    table_h = uitable('v0', h, table, title);
else
    table_h = uitable(h, table, title);
end

data.table_h = table_h;
set(table_h, 'Units', 'normalized');

pop_pos = get(H.channel_selecter_popup, 'Position');
ok_pos = get(H.ok_push, 'Position');

MARGIN = 0.05;
set(table_h, 'Position', [pop_pos(1), ok_pos(2)+ok_pos(4)+MARGIN, 0.8, 0.7]);
set(table_h, 'Units', 'normalized');

guidata(h, data);

waitfor(h, 'Visible', 'off');
if ishandle(h)
    data = guidata(h);
    if data.cancel_flag
        selected_ch_list = [];
        cancel = true;
    else
        tableData = cell(get(table_h, 'data'));
        flags = [tableData{:, 2}];
        ix = find(flags == 1);
        if ~isempty(ix)
            selected_ch_list = all_ch_list(ix);
        else
            selected_ch_list = [];
        end
    end
    delete(h);
end
