function [data] = vb_trial_extractor_tag_by_hand(data, list_index, tag)
% set tag to selected item
% [USAGE]
%    [data] = vb_trial_extractor_tag_by_hand(data, list_index, tag);
% [IN]
%          data : vb_trial_extractor object.
%    list_index : selected index on trial listbox. [Nx1]
%                 (not data index)
%           tag : tag name
% [OUT]
%          data : vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('list_index', 'var')
    error('list_index is a required parameter.');
end
if size(list_index, 2) ~= 1
    error('index shape should be [Nx1].');
end
if ~exist('tag', 'var')
    error('tag is a required parameter.');
end
if ~ischar(tag)
    error('tag should be string');
end

%
% --- Main Procedure
%

% Duplicate check between new tag and exist tags
exist_tags = cell(0);
for k=1:length(data.label_list)
    exist_tags{k} = vb_tag_get_tag_name(data.label_list{k});
end

dup_tags = cell(0);
dup_ix   = strmatch(tag, exist_tags, 'exact');

if ~isempty(dup_ix)
    dup_tags = exist_tags(dup_ix);
end

if length(dup_tags)
   msg = sprintf('Following labels already exists, Continue?\n');
   for k=1:length(dup_tags)
       msg = [msg, sprintf('%s\n', dup_tags{k})];
   end
   res = questdlg(msg, 'Confirm', 'Yes', 'No', 'Yes');
   if strcmpi(res, 'no')
       return;
   else
       data.label_list(dup_ix) = []; % remove duplicate tag.
   end
end

% Create new tag and register trial index
tag_obj = vb_tag_new(tag);

% extract data index
data_index = data.showing_trial_ix(list_index);

% register trial
tag_obj = vb_tag_add_trial_index(tag_obj, data_index);
data.label_list{length(data.label_list)+1} = tag_obj;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_trial_extractor obj.');
end
