function result = vb_trial_extractor_save_parm(data, file)
% Save parameter
% [USAGE]
%   [result] = vb_trial_extractor_save_parm(data, file);
% [IN]
%    data : 
%    file : 
% [OUT]
%    result : save result.
%             = SUCCESS
%             = FAILURE
%           
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('file', 'var')
    error('file is a required parameter.');
end

trx_parm = struct;

%
% --- Main Procedure
%
if isfield(data, 'continuous_file') && ~isempty(data.continuous_file)
    trx_parm.con_file = vb_continuous_file_get_filename(data.continuous_file);
else
    trx_parm.con_file = [];
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Trial Extraction section

% Trigger spec
trx_parm.trigger_list = data.trigger_list;

% Trial length
trx_parm.trial_setting = data.trial_setting;

% Trial list
trx_parm.trial_list = data.trial_list;

% Label list
trx_parm.label_list = data.label_list;

% Labeling spec
trx_parm.label_spec = struct;
trx_parm.label_spec.label_file = '';
trx_parm.label_spec.base_label = '';
if isfield(data, 'label_spec')
    trx_parm.label_spec = data.label_spec;
    trx_parm.label_spec.overwrite = true;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Output section
trx_parm.output_sample_freq = data.output_sample_freq;
trx_parm.output_file = data.output_file;


%
% --- Save parameter
%
result = vb_save(file, 'trx_parm');
