function [data] = vb_trial_extractor_init(h)
% initialize data
% [USAGE]
%    [data] = vb_trial_extractor_init;
% [IN]
%    none
% [OUT]
%    data : initialized member variable of vb_trial_extractor.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% Data structure
data = struct;

% Continuous file object(see continous_file_new)
data.continuous_file = [];

% Trigger list
data.trigger_list    = cell(0);

% Adjustment parameter for digital trigger
parm = struct;
parm.Data_offset = 0;
parm.Bitmask    = '';
data.trigger_adjust_parameter = parm;

% Extracted trial data
data.trial_list      = [];

% Tags for trial
data.label_list        = cell(0);

% Showing trial list index
data.showing_trial_ix = [];

% Viewer instance holder
data.viewer = cell(0);


% Output file list
% data.output_file{k}.label_name  = 'TRIGGER1'
%                    .output_file = 'TRIG1.meg.mat';
data.output_file   = cell(0);

% Trial setting
trial_setting  = struct;
trial_setting.pretrigger_ms  = 0;
trial_setting.posttrigger_ms = 0;
trial_setting.minimum_distance_ms = [];
data.trial_setting = trial_setting;

% EMG parameter(optional)
emg_parm.optional_parm.t_event = 500;
emg_parm.optional_parm.t_period = 50;
emg_parm.optional_parm.status_level = 1.0;
% EMG parameter(advanced)
emg_parm.advanced_parm.t_smooth = 25;
emg_parm.advanced_parm.p_val   = 0.001;
data.emg_parm = emg_parm;

% Voice parameter(optional)
voice_parm.optional_parm.t_period      = 100;
voice_parm.optional_parm.status_level  = 1.0;
% Voice parameter(advanced)
voice_parm.advanced_parm.p_val         = 0.0001;
voice_parm.advanced_parm.t_smooth      = 10;
data.voice_parm = voice_parm;

% Figure handle
data.figure = h;
data.H = guihandles(h);


%
% --- After check
%
if nargout ~= 1
    error('function caller should receive initialized data.');
end
