function [lib_parm] = vb_signal_processor_util_convert_parm_to_lib_parm(parm, freq)
% Convert parm for vb_signal_processor to parm for vb_filter_data.
% [USAGE]
%    [lib_parm] = vb_signal_processor_util_convert_parm_to_lib_parm(parm, freq);
% [IN]
%        parm : parameter formatted for vb_signal_processor.
%        freq : Sampling frequency of preprocess data.
% [OUT]
%    lib_parm : parameter formatted for vb_filter_data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('parm', 'var')
    error('parm is a required parameter.');
end
if ~exist('freq', 'var')
    error('freq is a required parameter.');
end

%
% --- Main Procedure
%
d = vb_define_signal_processor;

lib_parm = struct;
lib_parm.freq = freq;

switch(parm.type)
    case d.TYPE_PROCESSING_BIAS_CORRECTION
        lib_parm.bias_flg = parm.mode;
    case d.TYPE_PROCESSING_HIGHPASS
        lib_parm.filter_type = 'high';
        lib_parm.cutfreq          = parm.cutoff_freq;
        lib_parm.impulse_response = parm.impulse_response;
        lib_parm.order            = parm.order;
        lib_parm.online           = parm.filtfilt;
    case d.TYPE_PROCESSING_LOWPASS
        lib_parm.filter_type = 'low';
        lib_parm.cutfreq          = parm.cutoff_freq;
        lib_parm.impulse_response = parm.impulse_response;
        lib_parm.order            = parm.order;
        lib_parm.online           = parm.filtfilt;
    case d.TYPE_PROCESSING_BANDPASS
        lib_parm.filter_type = 'band';
        lib_parm.cutfreq          = [parm.cutoff_freq_low, parm.cutoff_freq_high];
        lib_parm.impulse_response = parm.impulse_response;
        lib_parm.order            = parm.order;
        lib_parm.online           = parm.filtfilt;
    case d.TYPE_PROCESSING_STOPBAND
        lib_parm.filter_type = 'stop';
        lib_parm.cutfreq          = [parm.cutoff_freq_low, parm.cutoff_freq_high];
        lib_parm.impulse_response = parm.impulse_response;
        lib_parm.order            = parm.order;
        lib_parm.online           = parm.filtfilt;
    case d.TYPE_PROCESSING_DOWNSAMPLE
        lib_parm.fsamp            = parm.dsamp_freq;
    case d.TYPE_PROCESSING_COMMON_REFERENCE
        lib_parm.common_flg       = parm.mode;
    otherwise
        error('Unknown parameter was specified.');
end
