function [item] = vb_signal_processor_util_convert_parm_to_editor(parm)
% convert parameter to editor's format.
% [USAGE]
%    item = vb_signal_processor_util_convert_parm_to_editor(parm);
% [IN]
%    parm : parameter.
% [OUT]
%    item : data for vb_input_settings(editor).
%
% See Also: vb_input_settings.m
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

d = vb_define_signal_processor;

switch(parm.type)
    case d.TYPE_PROCESSING_BIAS_CORRECTION
        % Bias correction
        item = { ...
            {'type', 'string input', 'title', 'mode', 'value', num2str(parm.mode), ...
             'help', ...
              sprintf(['0: No Bias correction.\n' ...
                       '1: Constant Bias correction by using all time samples.\n'...
                       '2: Linear trend removal and Constant Bias correction by using all time samples.\n'...
                       '[t1 t2]: Bias correction by time window [t1 t2] (msec). time is specified by [msec] from the begining of data.']);}; ...
        };
    case d.TYPE_PROCESSING_HIGHPASS
        % Highpass
        item = { ...
            {'type', 'string input', 'title', 'Cutoff frequency [Hz]', 'value', num2str(parm.cutoff_freq), ...
             'help', 'Cutoff frequency for highpass filter [Hz].'}, ...
            {'type', 'string input', 'title', 'Impulse response', 'value', num2str(parm.impulse_response), ...
             'help', '1:Finite impulse filter, 2:Butterworth filter'}, ...
            {'type', 'string input', 'title', 'Filter order', 'value', num2str(parm.order), ...
             'help', 'Filter order for Butterworth filter. For finite impulse filter, this value is not used.'}, ...
            {'type', 'string input', 'title' 'Time delay correction', 'value', num2str(parm.filtfilt), ...
             'help', sprintf('0: ''filter'' is applied for online filter case, \n1: Time delay correction is applied by using ''filtfilt''');}; ...
        };
    case d.TYPE_PROCESSING_LOWPASS
        % Lowpass
        item = { ...
            {'type', 'string input', 'title', 'Cutoff frequency [Hz]', 'value', num2str(parm.cutoff_freq), ...
             'help', 'Cutoff frequency for lowpass filter [Hz].'}, ...
            {'type', 'string input', 'title', 'Impulse response', 'value', num2str(parm.impulse_response), ...
             'help', '1:Finite impulse filter, 2:Butterworth filter.'}, ...
            {'type', 'string input', 'title', 'Filter order', 'value', num2str(parm.order), ...
             'help', 'Filter order for Butterworth filter. For finite impulse filter, this value is not used.'}, ...
            {'type', 'string input', 'title' 'Time delay correction', 'value', num2str(parm.filtfilt), ...
             'help', sprintf('0: ''filter'' is applied for online filter case, \n1: Time delay correction is applied by using ''filtfilt''');}; ...
        };
    case d.TYPE_PROCESSING_BANDPASS
        % Bandpass
        item = { ...
            {'type', 'string input', 'title', 'Lower cutoff frequency [Hz]', 'value', num2str(parm.cutoff_freq_low), ...
             'help', 'Lower cutoff frequency for bandpass filter.'}, ...
            {'type', 'string input', 'title', 'Higher cutoff frequency [Hz]', 'value', num2str(parm.cutoff_freq_high), ...
             'help', 'Higher cutoff frequency for bandpass filter.'}, ...
            {'type', 'string input', 'title', 'Impulse response', 'value', num2str(parm.impulse_response), ...
             'help', '1:Finite impulse filter, 2:Butterworth filter.'}, ...
            {'type', 'string input', 'title', 'Filter order', 'value', num2str(parm.order), ...
             'help', 'Filter order for Butterworth filter. For finite impulse filter, this value is not used.'}, ...
            {'type', 'string input', 'title' 'Time delay correction', 'value', num2str(parm.filtfilt), ...
             'help', sprintf('0: ''filter'' is applied for online filter case, \n1: Time delay correction is applied by using ''filtfilt''');}; ...
        };
    case d.TYPE_PROCESSING_STOPBAND
        % Bandpass
        item = { ...
            {'type', 'string input', 'title', 'Lower cutoff frequency [Hz]', 'value', num2str(parm.cutoff_freq_low), ...
             'help', 'Lower cutoff frequency for stop-band filter.'}, ...
            {'type', 'string input', 'title', 'Higher cutoff frequency [Hz]', 'value', num2str(parm.cutoff_freq_high), ...
             'help', 'Higher cutoff frequency for stop-band filter.'}, ...
            {'type', 'string input', 'title', 'Impulse response', 'value', num2str(parm.impulse_response), ...
             'help', '1:Finite impulse filter, 2:Butterworth filter.'}, ...
            {'type', 'string input', 'title', 'Filter order', 'value', num2str(parm.order), ...
             'help', 'Filter order for Butterworth filter. For finite impulse filter, this value is not used.'}, ...
            {'type', 'string input', 'title' 'Time delay correction', 'value', num2str(parm.filtfilt), ...
             'help', sprintf('0: ''filter'' is applied for online filter case, \n1: Time delay correction is applied by using ''filtfilt''');}; ...
        };
    case d.TYPE_PROCESSING_DOWNSAMPLE
        % Downsampling
        item = { ...
            {'type', 'string input', 'title', 'New sampling frequency [Hz]', 'value', num2str(parm.dsamp_freq), ...
             'help', 'New sampling frequency. Before downsampling, lowpass filtering with cutoff frequency less than ''New sampling frequency/2'' should be applied.'}; ...
        };
    case d.TYPE_PROCESSING_COMMON_REFERENCE
        % Common reference(for EEG)
        item = { ...
            {'type', 'string input', 'title', 'mode', 'value', num2str(parm.mode), ...
             'help', sprintf(['0:OFF, 1:ON.\nCommon reference is one way of EEG reference channel specification.',...
                      'For EEG data, reference voltage is assumed as the average of all channel data.', ...
                      'Namely, the average of all channel data is subtracted from each channel data for each time sample.']); };...
        };
    otherwise
        error('Unknown parameter type was specified.');
end

