function data = vb_signal_processor_add_tool_to_processlist(data, process_type)
% Add processing tool to processing list.
% [USAGE]
%    data = vb_signal_processor_add_tool_to_processlist(data, process_type);
% [IN]
%            data : Application data.
%    process_type : processing tool type [string]
% [OUT]
%    data : Updated application data.
% See Also:
%    vb_define_signal_processor.m
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('process_type', 'var') || ~ischar(process_type)
    error('Invalid processing tool was specified.');
end

%
% --- Main Procedure
%
parm = vb_signal_processor_get_default_parm(process_type);

Ntool = length(data.process_list);
data.process_list{Ntool+1} = parm;
set(data.H.process_list_listbox, 'Value', Ntool+1);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive data object.');
end
