function pa_leadfield_make_center_sphere(fig)
% make center sphere
% [USAGE]
%    pa_leadfield_set_parm(<fig>);
% [IN]
%    fig : figure handle of leafield gui.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

%
% --- Main Procedure
%

% load data(@see pa_leadfield_create)
data = guidata(fig);
H = data.H; % component handles

% analyze file input
[d_name, f_name] = vb_file_select({'.nii', '.hdr'}, 'Select MRI file');
if ~isempty(d_name)
    mri_file = [d_name, filesep, f_name{1}];
else
    % selection cancelled.
    return;
end


%
% --- run make sphere model gui.
%

% show wait bar
h = waitbar(0,'MRI file reading');
pause(0.01); % for draw waitbar.

% MRI data read
try
    avw = avw_read_ras(mri_file);
catch
    errordlg('cannot read mri file.', 'error');
    cancelled = true;
    return;
end

waitbar(100);


% current center info.
Vcenter = str2num(get(H.center_head_edit, 'String'));
if ~isempty(Vcenter)
    if isfield(data, 'Vradius')
        sphere.radius = data.Vradius;
    else
        sphere.radius = 0;
    end
    sphere.center = Vcenter;
    avw.sphere_on_spm_right_m = sphere;
end

% --- run gui
try
    % launching vb_sphere_head
    vb_sphere_head(avw);
    if ishandle(h), close(h); end
    % wait for close sphere_head.
    waitfor(gcf);
catch
    errordlg('something error occured in vb_sphere_head', 'error');
    return;
end

% returns sphere_data(radius, center)
try
    center = evalin('base', 'avw.center');
    radius = evalin('base', 'avw.radius');
catch
    % sphere model gui closed by x button.
    evalin('base', 'clear avw;');
    return;
end
evalin('base', 'clear avw;');

% save sphere
set(H.center_head_edit, 'String', num2str(center, 3));
data.Vradius = radius; % radius is officially not used.

guidata(fig, data);
