function H = pa_leadfield_parm_callback(hObject, H)
% This function process Leadfield parameter setting menu action
%
% hObject : component handle
% H       : structure with all component handles
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

switch( hObject )
    case { H.Leadfield_parm.recalc_on_button, H.Leadfield_parm.recalc_off_button }
        set(H.Leadfield_parm.recalc_on_button, 'Value', 0);
        set(H.Leadfield_parm.recalc_off_button, 'Value', 0);
        set(hObject, 'Value', 1);
    case H.Leadfield_parm.spherical_func_order_slider
        slider_value = fix(get(hObject, 'Value'));
        set(H.Leadfield_parm.spherical_func_order_edit, 'String', num2str(slider_value));
    case {H.Leadfield_parm.conductivity_csf_edit, ...
          H.Leadfield_parm.conductivity_skull_edit,...
          H.Leadfield_parm.conductivity_scalp_edit }
        check_conductivity(hObject, H);
    case {H.Leadfield_parm.relative_radius_csf_edit,...
          H.Leadfield_parm.relative_radius_skull_edit,...
          H.Leadfield_parm.relative_radius_scalp_edit}
        check_relative_radius(hObject, H);
end

function check_conductivity(hObject, H)
    value = str2double(get(hObject, 'String'));
    if value <= 0
        errordlg('Conductivity value should be positive.', 'error');
        v = CONDUCTIVITY_DEFAULT;
        % set default value
        switch(hObject)
            case H.Leadfield_parm.conductivity_csf_edit
                set(hObject, 'String', num2str(v(1)));
            case H.Leadfield_parm.conductivity_skull_edit
                set(hObject, 'String', num2str(v(2)));
            case H.Leadfield_parm.conductivity_scalp_edit
                set(hObject, 'String', num2str(v(3)));
        end
    end

function check_relative_radius(hObject, H)
    value = str2double(get(hObject, 'String'));
    if ~( (0 < value) && (value <= 1) ) % 0<value<=1
        errordlg('Relative radius value range should be (0 < value <=1)', 'error');
        v = RELATIVE_RADIUS_DEFAULT;
        % set default value
        switch(hObject)
            case H.Leadfield_parm.relative_radius_csf_edit
                set(hObject, 'String', num2str(v(1)));
            case H.Leadfield_parm.relative_radius_skull_edit
                set(hObject, 'String', num2str(v(2)));
            case H.Leadfield_parm.relative_radius_scalp_edit
                set(hObject, 'String', num2str(v(3)));
        end
    end
    
function v = CONDUCTIVITY_DEFAULT;
	% Conductivity  from innermost to outermost
    basis_parm = vb_set_basis_parm;
    v = basis_parm.sigma;

function v = RELATIVE_RADIUS_DEFAULT;
	% Relative radius of sphere from innermost to outermost
    basis_parm = vb_set_basis_parm;
	v = basis_parm.radius;
