function [head_parm] = pa_head_get_parm(fig)
% This function gets parameters from head GUI.
% [USAGE]
%   [head_parm] = pa_head_get_parm(<fig>);
% [IN]
%    fig : figure handle of head gui.
% [OUT]
%    head_parm : head_parm for vb_job_head_3shell()
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
% load data(@see pa_head_create)
data = guidata(fig);
H = data.H; % component handles

head_parm = struct;

% head_parm.Nsurf
if get(H.model_1shell_radiobutton, 'Value')
    head_parm.Nsurf = 1;
    head_parm.Nvertex = str2num(get(H.vertices_1shell_edit, 'String'));
elseif get(H.model_3shell_radiobutton, 'Value')
    head_parm.Nsurf = 3;
    head_parm.Nvertex = str2num(get(H.vertices_3shell_edit, 'String'));
end

% Voxel size
head_parm.vstep = str2num(get(H.voxel_size_edit, 'String'));

% Analyze file
head_parm.analyze_file = get(H.analyze_file_edit, 'String');

%
% --- CSF source
%
if get(H.csf_source_popup, 'Value') == 1
    % SPM segmentation file + Cortical model file
    head_parm.gray_file  = get(H.gray_file_edit, 'String');
    head_parm.brain_file = get(H.brain_file_edit, 'String');
    head_parm.Radius_csf = eval(get(H.gray_morphology_edit, 'String'));
    fs_file = get(H.fs_csf_file_edit, 'String');
    if ~isempty(fs_file)
        head_parm.freesurf_file = fs_file;
        head_parm.Radius_fs  = eval(get(H.fs_morphology_edit, 'String'));
    end
elseif get(H.csf_source_popup, 'Value') == 2
    % Curry v4.5 surface file
    head_parm.Radius = eval(get(H.curry_morphology_edit, 'String'));
    head_parm.curry_file = get(H.curry_file_edit, 'String');
else
    error('CSF source is invalid.');
end

%if head_parm.Nsurf > 1
    %
    % --- Skull source
    %
    if get(H.skull_source_popup, 'Value') == 1
        % use Scalp thickness
        head_parm.Radius_scalp = str2num(get(H.scalp_thickness_edit, 'String'));
    elseif get(H.skull_source_popup, 'Value') == 2
        % FreeSurfer surface file(outer skull)
        head_parm.fs_skull_file = get(H.fs_skull_file_edit, 'String');
    else
        error('Skull source is invalid.');
    end

    % Minimum skull thickness
    head_parm.Radius_skull = str2num(get(H.min_skull_thickness_edit, 'String'));
    
    %
    % --- Scalp source
    %
    if get(H.scalp_source_popup, 'Value') == 1
        % FreeSurfer surface file(outer skin)
        head_parm.fs_scalp_file = get(H.fs_scalp_file_edit, 'String');
    elseif get(H.scalp_source_popup, 'Value') == 2
        % Face file(made by positioning program)
        head_parm.face_file = get(H.face_file_edit, 'String');
    else
        error('Scalp source is invalid.');
    end
%end

% Output filename
head_base = get(H.head_file_edit, 'String');
head_parm.head_file = head_base;

