function pa_head_callback(fig, hObj)
% callback function for head gui.
% [USAGE]
%    pa_head_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of head gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure is specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_head_create)
data = guidata(fig);
H = data.H;

%get(gcbo, 'Tag')% debug
switch( hObj )
    case H.prjroot_push
        dir = dir_dialog(get(H.prjroot_edit, 'String'));
        if dir ~= 0
            set(H.prjroot_edit, 'String', dir);
        end
    case {H.vertices_1shell_edit, H.vertices_3shell_edit}
        pa_head_util(fig, 'update_output_fname');
    case H.analyze_file_push
        [dir fname] = vb_file_select({'.nii', '.hdr'}, 'Select MRI file');
        if ~isempty(dir)
            set(H.analyze_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_head_util(fig, 'update_output_fname');
    case {H.model_1shell_radiobutton, ...
          H.model_3shell_radiobutton }
        group = [H.model_1shell_radiobutton;
                 H.model_3shell_radiobutton];
        set(group, 'Value', 0);
        set(hObj, 'Value', 1);
        pa_head_util(fig, 'update_model_type');
        pa_head_util(fig, 'update_output_fname');
    case H.csf_source_popup
        pa_head_util(fig, 'update_csf_source');
        pa_head_util(fig, 'update_exec_push_status');
    case H.fs_csf_file_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.fs_csf_file_push
        [dir fname] = vb_file_select({'.asc'}, 'Select FreeSurfer surface file(inner skull)');
        if ~isempty(dir)
            set(H.fs_csf_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_head_util(fig, 'update_exec_push_status');
    case H.gray_file_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.gray_file_push
        [dir fname] = vb_file_select({'.nii', '.hdr'}, 'Select SPM gray file');
        if ~isempty(dir)
            set(H.gray_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_head_util(fig, 'update_exec_push_status');
    case H.brain_file_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.brain_file_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir fname canceled] = pa_prjfile_select(proj_root, {define.BRAIN_EXTENSION}, 'Select cortical model file');
        if ~canceled
            set(H.brain_file_edit, 'String', [dir filesep fname{1}]);
            pa_head_util(fig, 'update_exec_push_status');
        end
    case H.curry_file_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.curry_file_push
        [dir fname] = vb_file_select({'.*'}, 'Select Curry surface file');
        if ~isempty(dir)
            set(H.curry_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_head_util(fig, 'update_exec_push_status');
    case H.gray_morphology_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.curry_morphology_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.fs_morphology_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.skull_source_popup
        pa_head_util(fig, 'update_skull_source');
        pa_head_util(fig, 'update_exec_push_status');
    case H.fs_skull_file_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.fs_skull_file_push
        [dir fname] = vb_file_select({'.asc'}, 'Select FreeSurfer surface file(outer skull)');
        if ~isempty(dir)
            set(H.fs_skull_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_head_util(fig, 'update_exec_push_status');
    case H.min_skull_thickness_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.scalp_thickness_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.scalp_source_popup
        pa_head_util(fig, 'update_scalp_source');
        pa_head_util(fig, 'update_exec_push_status');
    case H.fs_scalp_file_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.fs_scalp_file_push
        [dir fname] = vb_file_select({'.asc'}, 'Select FreeSurfer surface file(outer skin)');
        if ~isempty(dir)
            set(H.fs_scalp_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_head_util(fig, 'update_exec_push_status');
    case H.face_file_edit
        pa_head_util(fig, 'update_exec_push_status');
    case H.face_file_push
        [dir fname] = vb_file_select({'.face.mat'}, 'Select Face surface file');
        if ~isempty(dir)
            set(H.face_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_head_util(fig, 'update_exec_push_status');
    case H.head_file_edit
        pa_head_util(fig, 'update_output_fname');
    case H.save_dir_edit
        pa_head_util(fig, 'update_output_fname');
    case H.save_dir_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir canceled] = pa_prjdir_select(proj_root);
        if ~canceled
            set(H.save_dir_edit, 'String', dir);
        end
        pa_head_util(fig, 'update_output_fname');
    case H.reset_push
        pa_head_util(fig, 'reset_parameter');
    case H.exec_push
        pa_head_util(fig, 'exec_head');
    case H.view2d_push
        pa_head_util(fig, 'view2d');
    case H.view3d_push
        pa_head_util(fig, 'view3d');
%     case H.head_parm_push
%         if ishandle(data.adv_fig)
%             figure(data.adv_fig);
%         else
%             data.adv_fig = pa_head_parm_gui_create(fig, data.head_parm);
%         end
    %%%%%%%%%%%
    % Menu
    case {H.figure, H.menu_close}
        pa_head_close(fig);
        return;
    case H.menu_about_head_model
        urls = vb_users_manual_url('Head model');
        vb_browser_show(urls{1});
    case H.menu_import_head_model
        urls = vb_users_manual_url('Head model');
        vb_browser_show(urls{2});
        
end

% save data
guidata(fig, data);
