function pa_fmri_parm_gui_callback(fig, hObj)
% callback function for fmri advanced parameter gui.
% [USAGE]
%    pa_fmri_parm_gui_callback(<fig> <,hObj>);
% [IN]
%     fig : figure handle of fmri advanced parameter gui.
%    hObj : event component handle
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end
if ~exist('hObj', 'var'), error('hObj is a required parameter.'); end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_fmri_create)
data = guidata(fig);
H = data.H;

switch( hObj )
    % set value from slider to editbox
    case H.T_value_edit
        val = str2num(get(H.T_value_edit, 'String'));
        if val <= 0
            pre_val = getappdata(hObj, 'pre_val');
            set(hObj, 'String', pre_val);
        end
    case H.spm_radius_edit
        val = str2num(get(H.spm_radius_edit, 'String'));
        if val <= 0
            pre_val = getappdata(hObj, 'pre_val');
            set(hObj, 'String', pre_val);
        end
    case H.PS_threshold_edit
        val = str2num(get(H.PS_threshold_edit, 'String'));
        if val <= 0
            pre_val = getappdata(hObj, 'pre_val');
            set(hObj, 'String', pre_val);
        end
    % button action
    case H.ok_push
        fmri_parm = pa_fmri_parm_gui_get_parm(fig);
        pa_fmri_merge_parm(data.parent_fig, fmri_parm);
        pa_fmri_parm_gui_close(fig);
    case H.cancel_push
        button = questdlg('Close Now?', 'fMRI_parm',...
                          'Yes', 'No',... % choice button type
                          'No');          % default choice
        if strcmp(button, 'Yes')
            pa_fmri_parm_gui_close(fig);
        end
end
