function pa_brain_set_parm(fig, brain_parm)
% This function sets parameters to brain GUI.
% [USAGE]
%    pa_brain_set_parm(<fig> [,brain_parm]);
% [IN]
%          fig : figure handle of brain gui.
%    brain_parm: to be set brain_parm  [default:vb_set_brain_parm()]
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

% default value
if isempty(brain_parm)
    brain_parm = vb_set_brain_parm;
end

%
% --- Main Procedure
%

% load data(@see pa_brain_create)
data = guidata(fig);

H = data.H; % component handles

% Analyze file
set(H.analyze_edit, 'String', brain_parm.analyze_file);

%
% --- BrainVoyager files
%
% Left-brain file
if isfield(brain_parm, 'BV_left_file') && ~isempty(brain_parm.BV_left_file);
    set(H.model_brainvoyager_radiobutton, 'Value', 1);
    set(H.left_edit, 'String', brain_parm.BV_left_file);
else
    set(H.model_brainvoyager_radiobutton, 'Value', 0);
end

% Right-brain file
if isfield(brain_parm, 'BV_right_file')
    set(H.right_edit, 'String', brain_parm.BV_right_file);
end

% Left-inflate file
if isfield(brain_parm, 'BV_left_infl_file');
    set(H.left_inflate_edit, 'String', brain_parm.BV_left_infl_file);
end

% Right-inflate file
if isfield(brain_parm, 'BV_right_infl_file')
    set(H.right_inflate_edit, 'String', brain_parm.BV_right_infl_file);
end

%
% --- FreeSurfer files
%
% Left-brain file
if isfield(brain_parm, 'FS_left_file') && ~isempty(brain_parm.FS_left_file)
    set(H.model_freesurfer_radiobutton, 'Value', 1);
    set(H.freesurfer_left_edit, 'String', brain_parm.FS_left_file);
else
    set(H.model_freesurfer_radiobutton, 'Value', 0);
end

% Right-brain file
if isfield(brain_parm, 'FS_right_file')
    set(H.freesurfer_right_edit, 'String', brain_parm.FS_right_file);
end

% Left-inflate file
if isfield(brain_parm, 'FS_left_infl_file')
    set(H.freesurfer_left_inflate_edit, 'String', brain_parm.FS_left_infl_file);
end

% Right-inflate file
if isfield(brain_parm, 'FS_right_infl_file')
    set(H.freesurfer_right_inflate_edit, 'String', brain_parm.FS_right_infl_file);
end

% Left-curv file
if isfield(brain_parm, 'FS_left_curv_file')
    set(H.freesurfer_left_curv_edit, 'String', brain_parm.FS_left_curv_file);
end

% Right-curv file
if isfield(brain_parm, 'FS_right_curv_file')
    set(H.freesurfer_right_curv_edit, 'String', brain_parm.FS_right_curv_file);
end

% Left-label file
if isfield(brain_parm, 'FS_left_label_file')
    set(H.freesurfer_left_label_edit, 'String', brain_parm.FS_left_label_file);
end

% Right-label file
if isfield(brain_parm, 'FS_right_label_file')
    set(H.freesurfer_right_label_edit, 'String', brain_parm.FS_right_label_file);
end

% Left-sphere file
if isfield(brain_parm, 'FS_left_sphere_file')
    set(H.freesurfer_left_sphere_edit, 'String', brain_parm.FS_left_sphere_file);
end

% Right-sphere file
if isfield(brain_parm, 'FS_right_sphere_file')
    set(H.freesurfer_right_sphere_edit, 'String', brain_parm.FS_right_sphere_file);
end

% SPM normalization file
if isfield(brain_parm, 'spm_normalization_file')
    set(H.spm_normalization_file_edit, 'String', brain_parm.spm_normalization_file);
end

% Save dir
[save_dir] = vb_get_file_parts(brain_parm.brain_file);
set(H.save_dir_edit, 'String', save_dir);

% BRAIN file
set(H.brain_file_edit, 'String', brain_parm.brain_file);

% AREA file
set(H.area_file_edit, 'String', brain_parm.area_file);

% Act file
set(H.act_file_edit, 'String', brain_parm.act_file);

% Default model
if get(H.model_brainvoyager_radiobutton, 'Value') == 0 && ...
   get(H.model_freesurfer_radiobutton, 'Value') == 0
    % FreeSurfer
    set(H.model_freesurfer_radiobutton, 'Value', 1);
end


% save brain_parm
data.brain_parm = brain_parm;
guidata(fig, data);

% view update
pa_brain_util(fig, 'update_model_type');
pa_brain_util(fig, 'update_output_fname');
