function pa_brain_callback(fig, hObj)
% callback function for brain gui.
% [USAGE]
%    pa_brain_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of brain gui.
%    hObj : event component handle.
% [OUT]
%    none
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure is specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_brain_create)
data = guidata(fig);
H = data.H;


switch( hObj )
    case H.prjroot_push
        dir = dir_dialog(get(H.prjroot_edit, 'String'));
        if dir ~= 0
            set(H.prjroot_edit, 'String', dir);
        end
    case H.analyze_push
        [dir fname] = vb_file_select({'.nii', '.hdr'}, 'Select MRI file');
        if ~isempty(dir)
            set(H.analyze_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_output_fname');
    case {H.model_brainvoyager_radiobutton, ...
          H.model_freesurfer_radiobutton }
        group = [H.model_brainvoyager_radiobutton;
                 H.model_freesurfer_radiobutton];
        set(group, 'Value', 0);
        set(hObj, 'Value', 1);
        pa_brain_util(fig, 'update_model_type');
        pa_brain_util(fig, 'update_exec_push_status');
    case H.left_push
        [dir fname] = vb_file_select({define.BV_EXTENSION}, 'Select LH surface file (BrainVoyager)');
        if ~isempty(dir)
            set(H.left_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.right_push
        [dir fname] = vb_file_select({define.BV_EXTENSION}, 'Select RH surface file (BrainVoyager)');
        if ~isempty(dir)
            set(H.right_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.left_inflate_push
        [dir fname] = vb_file_select({define.BV_EXTENSION}, 'Select LH inflate file (BrainVoyager)');
        if ~isempty(dir)
            set(H.left_inflate_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.right_inflate_push
        [dir fname] = vb_file_select({define.BV_EXTENSION}, 'Select RH inflate file (BrainVoyager)');
        if ~isempty(dir)
            set(H.right_inflate_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.fs_quick_input_push
        pa_brain_input_freesurfer_items(fig);
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_left_push
        [dir fname] = vb_file_select({define.FS_BRAIN_EXTENSION}, 'Select LH surface file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_left_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_right_push
        [dir fname] = vb_file_select({define.FS_BRAIN_EXTENSION}, 'Select RH surface file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_right_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_left_inflate_push
        [dir fname] = vb_file_select({define.FS_BRAIN_INFLATE_EXTENSION}, 'Select LH inflate file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_left_inflate_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_right_inflate_push
        [dir fname] = vb_file_select({define.FS_BRAIN_INFLATE_EXTENSION}, 'Select RH inflate file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_right_inflate_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_left_curv_push
        [dir fname] = vb_file_select({define.FS_CURV_EXTENSION}, 'Select LH curvature file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_left_curv_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_right_curv_push
        [dir fname] = vb_file_select({define.FS_CURV_EXTENSION}, 'Select RH curvature file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_right_curv_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_left_label_push
        [dir fname] = vb_file_select({'.cortex.label'}, 'Select Left cortex label file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_left_label_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_right_label_push
        [dir fname] = vb_file_select({'.cortex.label'}, 'Select Right cortex label file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_right_label_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');

    case H.freesurfer_left_sphere_push
        [dir fname] = vb_file_select({'.sphere.reg.asc'}, 'Select Left sphere file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_left_sphere_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.freesurfer_right_sphere_push
        [dir fname] = vb_file_select({'.sphere.reg.asc'}, 'Select Right sphere file (FreeSurfer)');
        if ~isempty(dir)
            set(H.freesurfer_right_sphere_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.spm_normalization_file_push
        [dir fname] = vb_file_select({'.mat'}, 'Select SPM normalization file');
        if ~isempty(dir)
            set(H.spm_normalization_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_brain_util(fig, 'update_exec_push_status');
    case H.save_dir_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir canceled] = pa_prjdir_select(proj_root);
        if ~canceled
            set(H.save_dir_edit, 'String', dir);
        end
        pa_brain_util(fig, 'update_output_fname');
    case H.change_output_filename_push
        res = inputdlg('', 'New output filename');
        if iscell(res) && length(res) >= 1
            res = res{1};
        end
        if ~isempty(res)
            data.output_filename = res;
            guidata(fig, data);
        end
        pa_brain_util(fig, 'update_output_fname');
    case H.brain_exec_push
        pa_brain_util(fig, 'exec_brain');
    case H.analyze_edit
        pa_brain_util(fig, 'update_output_fname');
        pa_brain_util(fig, 'update_exec_push_status');
    case {H.freesurfer_left_edit, ...
          H.freesurfer_right_edit, ...
          H.freesurfer_left_inflate_edit, ...
          H.freesurfer_right_inflate_edit, ...
          H.freesurfer_left_label_edit, ...
          H.freesurfer_right_label_edit, ...
          H.freesurfer_left_sphere_edit, ...
          H.freesurfer_right_sphere_edit, ...
          H.spm_normalization_file_edit}
          pa_brain_util(fig, 'update_exec_push_status');
    case H.save_dir_edit
        pa_brain_util(fig, 'update_output_fname');
    case H.brain_parm_push
        if ishandle(data.adv_fig)
            figure(data.adv_fig);
        else
            data.adv_fig = pa_brain_parm_gui_create(fig, data.brain_parm);
        end
    %%%%%%%%%%%%%%%%%%%%%%%%%    
    % Menu
    case {H.figure, H.menu_close}
        pa_brain_close(fig);
        return;
    case H.menu_about_image
        vb_browser_show(vb_users_manual_url('MR image preprocessing'));
    case H.menu_about_cortical_model
        urls = vb_users_manual_url('Cortical surface model');
        vb_browser_show(urls{1});
    case H.menu_import_cortical_model
        urls = vb_users_manual_url('Cortical surface model');
        vb_browser_show(urls{2});
end

% save data
guidata(fig, data);
