function pa_brain_parm_gui_callback(fig, hObj)
% callback function for brain advanced parameter gui.
% [USAGE]
%    pa_brain_parm_gui_callback(fig, hObj);
% [IN]
%     fig : figure handle of brain advanced parameter gui.
%    hObj : event component handle
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end
if ~exist('hObj', 'var'), error('hObj is a required parameter.'); end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_brain_create)
data = guidata(fig);
H = data.H;

switch( hObj )
    % set value from slider to editbox
    case H.rmax_slider
        val = get(H.rmax_slider, 'Value'); % [mm]
        set(H.rmax_edit, 'String', int2str(val));
    case H.reduce_ratio_slider
        val = get(H.reduce_ratio_slider, 'Value'); % [mm]
        set(H.reduce_ratio_edit, 'String', num2str(val));
    case H.nstep_slider
        val = get(H.nstep_slider, 'Value');
        set(H.nstep_edit, 'String', int2str(val));
    case H.display_slider
        val = get(H.display_slider, 'Value');
        set(H.display_edit, 'String', int2str(val));
    % set value from editbox to slider
    case H.rmax_edit
        val = str2num(get(H.rmax_edit, 'String'));
        set(H.rmax_slider, 'Value', val);
    case H.reduce_ratio_edit
        val = str2num(get(H.reduce_ratio_edit, 'String'));
        set(H.reduce_ratio_slider, 'Value', val);
    case H.nstep_edit
        val = str2num(get(H.nstep_edit, 'String'));
        set(H.nstep_slider, 'Value', val);
    case H.display_edit
        val = str2num(get(H.display_edit, 'String'));
        set(H.display_slider, 'Value', val);
    % button action
    case H.ok_push
        brain_parm = pa_brain_parm_gui_get_parm(fig);
        pa_brain_merge_parm(data.parent_fig, brain_parm);
        pa_brain_parm_gui_close(fig);
    case H.cancel_push
        button = questdlg('Close Now?', 'brain_parm',...
                          'Yes', 'No',... % choice button type
                          'No');          % default choice
        if strcmp(button, 'Yes')
            pa_brain_parm_gui_close(fig);
        end
end
