function pa_biosemi_eeg_callback(fig, hObj)
% callback function for yokogawa meg gui.
% [USAGE]
%    pa_biosemi_eeg_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of yokogawa meg gui.
%    hObj : event component handle.
% [OUT]
%    none
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure is specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_biosemi_eeg_create)
data = guidata(fig);
H = data.H;

switch(hObj)
    case H.project_root_push
        dir_name = dir_dialog(get(H.project_root_edit, 'String'));
        if dir_name ~= 0
            set(H.project_root_edit, 'String', dir_name);
        end
    case H.bdf_file_push
        [dir_name fname] = vb_file_select({define.BIOSEMI_DATA_EXTENSION}, ...
                                          'Select Biosemi EEG file');
        if ~isempty(dir_name)
            set(H.bdf_file_edit, 'String', [dir_name filesep fname{1}]);
        end
        pa_biosemi_eeg_util(fig, 'update_output_fname');
    case H.position_file_push
        [dir_name fname] = vb_file_select({'.pos.mat'}, ...
                                          'Select positioning file');
        if ~isempty(dir_name)
            set(H.position_file_edit, 'String', ...
                                      [dir_name filesep fname{1}]);
        end
    case H.binary_dir_edit
        pa_biosemi_eeg_util(fig, 'update_output_fname');
    case H.binary_dir_push
        proj_root = get(H.project_root_edit, 'String');
        [dir_name cancelled] = pa_prjdir_select(proj_root);
        if ~cancelled
            set(H.binary_dir_edit, 'String', dir_name);
        end
    case H.save_dir_push
        proj_root = get(H.project_root_edit, 'String');
        [dir_name cancelled] = pa_prjdir_select(proj_root);
        if ~cancelled
            set(H.save_dir_edit, 'String', dir_name);
        end
        pa_biosemi_eeg_util(fig, 'update_output_fname');
    case H.change_output_file_push
        res = inputdlg('', 'New output filename');
        if iscell(res) && length(res) >= 1
            res = res{1};
        end
        if ~isempty(res)
            data.output_filename = res;
            guidata(fig, data);
        end
        pa_biosemi_eeg_util(fig, 'update_output_fname');
    case H.exec_push
        pa_biosemi_eeg_util(fig, 'execute');
    %%%%%%%%%%%%%%%
    %  Menu
    case {H.figure, H.menu_close}
        pa_biosemi_eeg_close(fig);
        return;
    case H.menu_import_eeg_data
        url = vb_users_manual_url('EEG data');
        vb_browser_show(url);
end

% save data
guidata(fig, data);
