function [current_parm, cancelled] = current_gui_advanced(varargin)
% Edit dvanced parameter of current_parm field and return.
% [USAGE]
%    [current_parm] = current_gui_advanced('init' [,current_parm]);
% [IN]
%    varargin{1} : command
%    varargin{2} : command parameter
% [OUT]
%    current_parm : updated current_parm
%       cancelled : cancelled to input.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin == 0
    key = 'init';
else
    key = varargin{1};
end

if ~strcmp(key, 'init')
    h = get(0, 'CurrentFigure');
    data = figure_load_data(h);
end


switch(key)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % --- public
    % These interfaces are able to use from external function.
    case 'init'
         if nargin < 2
             current_parm = [];
         else
             current_parm = varargin{2};
         end
        % multiple launching of the allication is prohibited.
        h = findobj('Name', APPLICATION_NAME);
        if ~isempty(h)
            res = questdlg('Already opened. Reopen?',...
                                'confirm', 'Yes', 'No', 'Yes');
            if strcmp(res, 'Yes')
                destruct_gui;
            else
                % figure pull up to top.
                figure(h);
                return;
            end
        end
        % create gui
        data = create_gui(current_parm);
        figure_save_data(data.H.figure, data);
        
        % wait for figure property Visible = off
        waitfor(data.H.figure, 'Visible', 'off');

        % get return data
        data = figure_load_data(data.H.figure);
        cancelled    = data.cancelled;
        current_parm = data.current_parm;
        % delete figure
        destruct_gui;
        return;
    case 'exit'
         destruct_gui;
         return;
    case 'set_parm'
        current_parm = varargin{2};
        set_parm_gui(data, current_parm);
    case 'get_parm'
        current_parm = get_parm_gui(data);
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % --- private
    % These interfaces are for current_gui_advanced.
    % Don't use from external function.
    %
    case 'callback'
        hObj = varargin{2};
        data = callback(data, hObj);
end
% Save application data to the figure.
figure_save_data(data.H.figure, data);


function [data] = create_gui(current_parm)
% create figure and application data.
% [IN]
%    current_parm : current parameter
% [OUT]
%    data : application data
%           .H            : gui component handles
%           .H.figure     : figure handle
%           .cancelled    : cancel button pushed flag(true or false)
%           .current_parm : current parameter to return

    fig = openfig('current_gui_advanced');
    H = guihandles(fig);
    H.figure = fig;
    set(fig, 'Name', APPLICATION_NAME);

    % make application data
    data = struct;
    data.H = H;
    data.cancelled = false;
    data.current_parm = current_parm;

% end of create_gui();

function destruct_gui
% destruct figure
% [IN]
%    none
% [OUT]
%    none

    h = get(0, 'CurrentFigure');
    if strcmp(get(h, 'Name'), APPLICATION_NAME)
    else
        h = findobj('Name', APPLICATION_NAME);
    end
    try
        delete(h);
    catch
    end
% end of destruct_gui()

function figure_save_data(fig, data)
% Save application data to the figure
% [IN]
%    fig : figure handle for save.
%   data : @see create_gui
    guidata(fig, data);
% end of figure_save_data()

function [data] = figure_load_data(fig)
% Load application data from the figure
    data = [];
    if isempty(fig) || ~ishandle(fig)
        data.current_parm = [];
        data.cancelled = true;
    else
        data = guidata(fig);
    end
% end of figure_load_data()

function [data] = callback(data, hObj)
% This function will called by gui event.
% [IN]
%    data : application data (@see create_gui())
%    hObj : gui component handle(event)
% [OUT]
%    data : application data (@see create_gui())

H = data.H;
switch(hObj)
    case {H.overlapped_radiobutton, H.concatenate_radiobutton}
        radiobutton_group = [H.overlapped_radiobutton, ...
                             H.concatenate_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case H.cancel_push
        data.cancelled = true;
        set(H.figure, 'Visible', 'off');
    case H.ok_push
        data.current_parm = get_parm_gui(data);
        data.cancelled = false;
        set(H.figure, 'Visible', 'off');
end

get(hObj, 'Tag')


function current_parm = get_parm_gui(data)
    current_parm = [];

function v = APPLICATION_NAME
    v = 'current_parm';

