function [obj] = brain_file_maker_set_output_filename(obj)
% make output brain filename(for mask file) and 
% set it to brain_file_maker object
% [USAGE]
%    [obj] = brain_file_maker_set_output_filename(<obj>);
% [IN]
%    obj : brain_file_maker object
% [OUT]
%    obj : brain_file_maker object
%
% Author: rhayashi
% Created: 2007-07-27
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
global vbmeg_inst;

H = obj.H;

base_file = [obj.brain_file_output_dir, filesep, obj.brain_file_output_filename];
obj.output_mask_file  = [base_file, '.mask.mat'];
obj.output_brain_file = [base_file, vbmeg_inst.const.BRAIN_EXTENSION];
obj.output_area_file  = [base_file, vbmeg_inst.const.AREA_EXTENSION];
obj.output_act_file   = [base_file, vbmeg_inst.const.FMRI_EXTENSION];

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
