function [item_list] = history_get_item_all(obj)
% get all items
% [USAGE]
%    [item_list] = history_get_item_all(<obj>);
% [IN]
%    obj : history object
% [OUT]
%    item_list : cell array of item.
%                item_list{k}.description  % <<string>> history explanation
%                item_list{k}.parm         % <<struct>> parameter
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
item_list = obj.item_list;
