function [description, parm] = history_get_item(obj, index_no)
% get description and processing parameter.
% [USAGE]
%    [description, proc_parm] = history_get_item(<obj>, <index_no>);
% [IN]
%         obj : history object
%    index_no : index number of history(scalar)
% [OUT]
%    description : <<string>>    explanation of history 
%           parm : <<structure>> parameter
%
% --- Previous check
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('index_no', 'var')
    error('index_no is a required parameter.');
end
if length(index_no) > 1
    error('index_no should be scalar');
end
len = history_get_length(obj);
if len < index_no
    error('specified index_no is invalid.');
end

%
% --- Main Procedure
%
description = obj.item_list{index_no}.description;
parm        = obj.item_list{index_no}.parm;
