function [obj] = brain_data_set_history(obj, history)
% set history object to brain_data.
% [USAGE]
%    [obj] = brain_data_set_history(<obj>, <history>);
% [IN]
%        obj : brain_data object
%    history : history list
% [OUT]
%    obj : brain_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('history', 'var')
    error('history is a required parameter.');
end

%
% --- Main Procedure
%
obj.history = history;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
