function [obj] = brain_data_set_coord_type(obj, coord_type)
% set coordinate type
% [USAGE}
%    [obj] = brain_data_set_coord_type(<obj>, <coord_type>);
% [IN]
%           obj : brain_data object
%    coord_type : coordinate type to set
% [OUT]
%    obj : brain_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('coord_type', 'var')
    error('coord_type is a required parameter.');
end

%
% --- Main Procedure
%
obj.coord_type = coord_type;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
