function [obj] = brain_data_add_history_item(obj, description, proc_parm)
% add processing history to brain_data.
% [USAGE]
%    [obj] = brain_data_add_history_item(<obj>, <description>[, proc_parm]);
% [IN]
%            obj : brain_data object
%    description : comment
%      proc_parm : processing parameter object.
% [OUT]
%    obj : brain_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('description', 'var')
    error('description is a required parameter.');
end

%
% --- Main Procedure
%
if ~exist('proc_parm', 'var') || isempty(proc_parm)
    proc_parm = [];
end
obj.history = history_add_item(obj.history, description, proc_parm);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
