function [new_brain_data] = bm_processor_surf_smooth_expand(obj, brain_data, parm)
% processing by vb_surf_smooth_expand()
% [USAGE]
%     [new_brain_data] =
%         bm_processor_surf_smooth_expand(<obj>, <brain_data>, <parm>);
% [IN]
%           obj : bm_processor object
%    brain_data : processing data
%          parm : processing parameter
% [OUT]
%    new_brain_data : processed data
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_data', 'var')
    error('brain_data is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

if ~strcmp(brain_data.class_type, 'surf_data')
    error('Not surface data was inputted.');
end
if isempty(obj.analyze_info)
    error('Analyze file information does not exist.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
const = vbmeg_inst.const;

% get processing data
V  = surf_data_get_vertex(brain_data);
F  = surf_data_get_face(brain_data);
xx = surf_data_get_normal_vector(brain_data);

% calculate dimension
Vdim  = vb_analyze_info_get_voxdim(obj.analyze_info);
Vsize = vb_analyze_info_get_voxsize(obj.analyze_info);
parm.Dim = vb_mask_image_size(Vdim, Vsize, parm.vsize);

% processing
[V_new, F_new, xx_new] = vb_surf_smooth_expand(V, F, xx, parm);

% create new data
new_brain_data = surf_data_new(V_new, F_new, xx_new, ...
                                const.COORDINATE_ANALYZE_RIGHT_MM);
