function [index] = bm_manager_get_bm_list_index(obj)
% get display brain model index
% [USAGE]
%    [index] = bm_manager_get_bm_list_index(<obj>);
% [IN]
%    obj : bm_manager object
% [OUT]
%    index : index(Nx1)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_manager')
    error('class type is invalid.');
end

%
% --- Main Procedure
%
index = bm_list_get_brain_model_index(obj.bm_list);
