function [obj, index] = bm_list_delete_model(obj, index)
% delete model.
% [USAGE]
%    [obj, index] = bm_list_delete_model(<obj>, <index>);
% [IN]
%      obj : bm_list object
%    index : delete index
% [OUT]
%      obj : updated bm_list object
%    index : updated index
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('index', 'var'), error('index is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_list')
    error('class type is invalid.');
end

%
% --- Main Procedure
%

% Check specified index collect?
before_del_index = bm_list_get_brain_model_index(obj);
for k=1:length(index)
    if isempty(find(before_del_index == index(k)))
        error('specified index is invalid.');
    end
end

% setdiff returns difference index between A and B.
save_index = setdiff(before_del_index, index); 

% delete model
obj.brain_data_list = obj.brain_data_list(save_index);

% index after delete
index = bm_list_get_brain_model_index(obj);


%
% --- After check
%
if nargout == 0
    error('function caller should receive obj.');
end
