function [result] = bm_fileio_write_head_file(out_file, ...
                                            V_cell, F_cell, xx_cell, ...
                                            model_name_cell, conduct_cell);
% write head file
% [USAGE]
%    [result] = bm_fileio_write_head_file(
%                <out_file>, <V_cell>, <F_cell>, <xx_cell>,
%                <model_name_cell>, <conduct_cell>);
% [IN]
%           out_file : output head file(fullpath)
%             V_cell : cell array of vertex
%             F_cell : cell array of face
%            xx_cell : cell array of normal vector
%    model_name_cell : cell array of model name
%       conduct_cell : cell array of conductivity
% [OUT]
%    result : file write result(SUCCESS or FAILURE)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('out_file', 'var')
    error('out_file is a required parameter.');
end
if ~exist('V_cell', 'var')
    error('V_cell is a required parameter.');
end
if ~exist('F_cell', 'var')
    error('F_cell is a required parameter.');
end
if ~exist('xx_cell', 'var')
    error('xx_cell is a required parameter.');
end
if ~exist('model_name_cell', 'var')
    error('model_name_cell is a required parameter.');
end
if ~exist('conduct_cell', 'var')
    error('conduct_cell is a required parameter.');
end

%
% --- Main Procedure
%
result = SUCCESS;
% try
%     Nmodel = length(V_cell)
%     temp_head_file = cell(1, Nmodel);
% 
%     for k=1:Nmodel
%         Headinfo = [];
%         Headinfo = vb_headinfo_make(Headinfo, V_cell{k}, F_cell{k}, xx_cell{k},...
%                                  model_name_cell{k}, conduct_cell{k});
%         [path_name, name, ext] = fileparts([tempname '.head.mat']);
%         temp_head_file{k} = [name, ext];
%         vb_headinfo_save(Headinfo, [path_name filesep temp_head_file{k}]);
%     end
%     [path_name, name, ext] = fileparts(temp_head_file{1});
%     vb_util_join_head_files(temp_head_file, tempdir, out_file, ...
%                         [], model_name_cell, [], [], 1);
% catch
%     result = FAILURE;
% end

try
    Nmodel = length(V_cell);
    temp_head_file = cell(1, Nmodel);
    Headinfo_list = [];

    for k=1:Nmodel
        Headinfo = [];
        Headinfo = vb_headinfo_make(Headinfo, V_cell{k}, F_cell{k}, xx_cell{k},...
                                 model_name_cell{k}, conduct_cell{k});
        Headinfo_list = [Headinfo_list; Headinfo];
    end
    % export
     vb_headinfo_join(Headinfo_list, out_file);
catch
    result = FAILURE;
end
