function [obj] = bm_fileio_set_bm_list(obj, bm_list)
% set bm_list to bm_file object
% [USAGE]
%    [obj] = bm_fileio_set_bm_list(<obj>, <bm_list>);
% [IN]
%    obj : bm_fileio object
% [OUT]
%    bm_list : bm_list object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('bm_list', 'var'), error('bm_list is a required parameter.'); end

%
% --- Main Procedure
%
obj.bm_list = bm_list;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end

