function [V_cell, F_cell, xx_cell, model_name_cell, conduct_cell] = ...
                bm_fileio_read_brain_file(file_name, parts, analyze_info)
% read brain file.
% [USAGE]
%    [V_cell, F_cell, xx_cell, model_name_cell, conduct_cell] ...
%             = bm_fileio_read_brain_file(<file_name>, <parts>);
% [IN]
%    file_name : full path brain file(.brain.mat)
%        parts : parts to read.  cell array
% [OUT]
%             V_cell : cell array of vertex
%             F_cell : cell array of face
%            xx_cell : cell array of normal vector
%    model_name_cell : cell array of model name
%       conduct_cell : cell array of conductivity
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('file_name', 'var')
    error('file_name is a required parameter.');
end
if ~exist('parts', 'var')
    error('parts is a required parameter.');
end

if exist(file_name, 'file') ~= 2
    error(['specified brain file does not exist : ' file_name]);
end

%
% --- Main Procedure
%
const = define_bm_edit_app;

[V, F] = vb_load_cortex(file_name, 'subj');

% Analyze information for coordinate change
Vdim  = vb_analyze_info_get_voxdim(analyze_info);
Vsize = vb_analyze_info_get_voxsize(analyze_info);
V     = vb_spm_right_to_analyze_right_mm(V, Vdim, Vsize);
step  = 2;
Dim   = vb_mask_image_size(Vdim, Vsize, step);
mask_mode = 0; % no morphology

for k=1:length(parts)
    switch(parts{k})
        case const.str.BRAIN_FILE_IMPORT_LEFT_BRAIN
            B = vb_cortex_fill(V, F, step, [], 'L', Dim, mask_mode);
            model_name = const.str.BRAIN_FILE_IMPORT_LEFT_BRAIN;
        case const.str.BRAIN_FILE_IMPORT_RIGHT_BRAIN
            B = vb_cortex_fill(V, F, step, [], 'R', Dim, mask_mode);
            model_name = const.str.BRAIN_FILE_IMPORT_RIGHT_BRAIN;
        case const.str.BRAIN_FILE_IMPORT_WHOLE_BRAIN
            B = vb_cortex_fill(V, F, step, [], 'LR', Dim, mask_mode);
            model_name = const.str.BRAIN_FILE_IMPORT_WHOLE_BRAIN;
        otherwise
            error('specified type is invalid.');
    end

    [F_cell{k}, Vana, xx_cell{k}] = vb_surf_extract(B, step);
    V_cell{k} = vb_analyze_right_mm_to_spm_right(Vana, Vdim, Vsize);
    conduct_cell{k} = const.DEFAULT_CONDUCTIVITY;
    model_name_cell{k} = parts{k};

end

