function [obj] = bm_edit_app_view3d_make_figure(obj, view_setting3d)
% make figure.
% [USAGE]
%    [h] = bm_edit_app_view3d_make_figure(<obj>, <view_setting3d>);
% [IN]
%               obj : bm_edit_app_view3d object
%    view_setting3d : 3d view setting object
% [OUT]
%    h : figure handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('view_setting3d', 'var')
    error('view_setting3d is a required parameter.');
end

%
% --- Main Procedure
%
obj.h = openfig('bm_edit_app_view3d.fig');

H = guihandles(obj.h);

% axis off
set(obj.h, 'CurrentAxes', H.model_axes);
axis off;
set(obj.h, 'CurrentAxes', H.selected_axes);
axis off;

% tranceparent setting
contents = [1:-0.1:0];
for k=1:length(contents)
    contents_str{k} = num2str(contents(k));
end
set(H.tranceparent_popup, 'String', contents_str);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
