function [obj] = bayes_parm_editor_init(proj_root, bayes_parm)
% This function creates bayes parameter gui.
% [USAGE]
%    obj = bayes_parm_editor_init([proj_root] [,bayes_parm]);
% [IN]
%     proj_root : project root directory
%    bayes_parm : bayes_parm
% [OUT]
%    obj : bayes_parm_editor object(invisible figure)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proj_root', 'var')
    proj_root = '';
end
if ~exist('bayes_parm', 'var') || isempty(bayes_parm)
    bayes_parm = vb_set_bayes_parm;
end

%
% --- Main Procedure
%
obj = figure('Visible', 'off');

data = struct;
data.obj = obj;
data.bayes_parm = bayes_parm;

% figure handle of basic parameter gui.
data.basic_fig = bayes_parm_basic_init(obj, proj_root, bayes_parm);
data.adv_fig   = -1;

data.meg_info = [];
data.sensor_noise_info = [];
if isfield(bayes_parm, 'a0_act') && isempty(bayes_parm.a0_act)
    data.a0_act_auto = true;
else
    data.a0_act_auto = false;
end
% save data
guidata(obj, data);

% View update
bayes_parm_basic_gui(data.basic_fig, 'set_project_root', proj_root);
bayes_parm_basic_gui(data.basic_fig, 'gui_update', data.bayes_parm);
