function varargout = bayes_parm_advanced_gui(fig, command, varargin)
% This function shows bayes advanced parameters editor gui.
%
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end
if ~exist('command', 'var') || isempty(command)
    error('command is a required parameter.');
end

%
% --- Main Procedure
%

% load data (@see bayes_parm_advanced_init)
data = guidata(fig);
H = data.H; % component handles

switch(command)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % GUI initialize/exit/update functions
    %
    case 'init_gui'
        bayes_parm = varargin{2};
        
        H = init(H);
        set_gui_parms(data, bayes_parm);
    case 'exit_gui'
        try
            if isfield(H, 'fig')
                delete(H.fig);
            else
                delete(get(0, 'CurrentFigure'));
            end
        catch
            delete(get(0, 'CurrentFigure'));
        end
        clear H;
        bayes_parm_editor('exit_advanced_gui');
    case 'close_gui'
        if ~isempty(H)
            data = callback(H, H.OK_push);
        end
    case 'set_parm'
        bayes_parm = varargin{1};
        set_gui_parms(data, bayes_parm);
    case 'get_parm'
        [bayes_parm, a0_act_auto] = get_gui_parms(H);
        varargout{1} = bayes_parm;
        varargout{2} = a0_act_auto;
    case 'get_default'
        H = init(H);
        set(H.fig, 'Visible', 'off');
        bayes_parm = get_gui_parms(H);
        varargout{1} = bayes_parm;
        varargout{2} = get(H.a0_act_checkbox, 'Value');
        close(H.fig);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % GUI component handles getter function
    %
    case 'get_gui_handles'
        varargout{1} = H;

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % GUI component's call back function
    case 'callback'
        hObj = varargin{1};
        data = callback(data, hObj);
end

function H = init(H)
%
% This function initialize advanced parameter editor GUI.
%
% [IN]  H : structure of advanced parm gui object handles.
%       bayes_parm : bayes parameters.
% [OUT] H : structure of advanced parm gui object handles.
%
    % singleton
    if isfield(H, 'fig')
        figure(H.fig);
        return;
    end
    
    % open figure
    fig = openfig('bayes_parm_editor_advanced.fig');
    H = guihandles(fig);
    H.fig = fig;
    
    

function data = callback(data, hObj)
% callback function for bayes advanced parameter gui.
% [IN]
%    data : application data (@see bayes_parm_advanced_init)
%    hObj : event component
% [OUT]
%    data : some updated application data

    global vbmeg_inst;
    define = vbmeg_inst.const;
    
    H = data.H; % component handles

    switch(hObj)
    case H.a0_act_checkbox
        bayes_parm_editor(data.main_obj, 'set_a0_act_auto', get(hObj, 'Value'));
        H = update_a0_act_mode(H);
        %case H.reduce_slider
        %reduce_str = num2str(get(H.reduce_slider, 'Value'));
        %set(H.reduce_edit, 'String', reduce_str);
    case H.reduce_global_slider
        reduce_global_str = num2str(get(H.reduce_global_slider, 'Value'));
        set(H.reduce_global_edit, 'String', reduce_global_str);
    case H.basis_file_add_push
        common = bayes_parm_editor_get_basic_gui_common(data.main_obj);
        [dirname fname selected] = bayes_parm_gui_util('filedlg_relative',...
                                                        {define.BASIS_EXTENSION},...
                                                        0,...
                                                        common.proj_root);
        if selected
            num = length(fname);
            add_files = {};
            for n=1:num
                add_files = [add_files; cellstr([dirname filesep fname{n}])];
            end
            filenames = get(H.basisfile_global_listbox, 'String');
            set(H.basisfile_global_listbox, 'String', [filenames;add_files]);
        end
    case H.basis_file_remove_push
        idx = get(H.basisfile_global_listbox, 'Value');
        filenames = get(H.basisfile_global_listbox, 'String');
        if ~isempty(filenames)
            filenames(idx) = [];
            list_focus = idx(1)-1;
            if idx(1)-1 == 0
                list_focus = 1;
            end
            set(H.basisfile_global_listbox, 'Value', list_focus);
            set(H.basisfile_global_listbox, 'String', filenames);
        end
    case {H.soft_mode_on_radiobutton, H.soft_mode_off_radiobutton}
        radiobutton_group = [H.soft_mode_on_radiobutton, H.soft_mode_off_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
        % soft_mode = ON,  --> variance_orientation = ON
        %           = OFF, --> variance_orientation = OFF
        if hObj == H.soft_mode_on_radiobutton
            set(H.variance_orientation_on_radiobutton, 'Value', 1);
            set(H.variance_orientation_off_radiobutton, 'Value', 0);
        else
            set(H.variance_orientation_on_radiobutton, 'Value', 0);
            set(H.variance_orientation_off_radiobutton, 'Value', 1);
        end
    case {H.cont_pr_on_radiobutton, H.cont_pr_off_radiobutton}
        radiobutton_group = [H.cont_pr_on_radiobutton, H.cont_pr_off_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case {H.temporal_filter_on_radiobutton, H.temporal_filter_off_radiobutton}
        radiobutton_group = ...
            [H.temporal_filter_on_radiobutton, H.temporal_filter_off_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case {H.trial_average_on_radiobutton, H.trial_average_off_radiobutton}
        radiobutton_group = ...
            [H.trial_average_on_radiobutton, H.trial_average_off_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case {H.expand_spatial_filter_on_radiobutton, H.expand_spatial_filter_off_radiobutton}
        radiobutton_group = ...
            [H.expand_spatial_filter_on_radiobutton, H.expand_spatial_filter_off_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case {H.variance_orientation_on_radiobutton, H.variance_orientation_off_radiobutton}
        radiobutton_group = ...
            [H.variance_orientation_on_radiobutton, H.variance_orientation_off_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case {H.patch_size_normalization_on_radiobutton, H.patch_size_normalization_off_radiobutton}
        radiobutton_group = ...
            [H.patch_size_normalization_on_radiobutton, H.patch_size_normalization_off_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case {H.remove_crossed_area_on_radiobutton, H.remove_crossed_area_off_radiobutton}
        radiobutton_group = ...
            [H.remove_crossed_area_on_radiobutton, H.remove_crossed_area_off_radiobutton];
        set(radiobutton_group, 'Value', 0);
        set(hObj, 'Value', 1);
    case H.OK_push
        bayes_parm_advanced_close(H.figure, true);
    case H.CANCEL_push
        bayes_parm_advanced_close(H.figure, false);
    end

function set_gui_parms(data, bayes_parm)
% set parameters to gui.
% [IN]
%           data : application data (@see bayes_parm_advanced_init)
%     bayes_parm : initialize parameter.

    if isempty(bayes_parm)
        return;
    end
    H = data.H; % component handles
    
    % This is not a member of bayes_parm
    set(H.a0_act_checkbox, 'Value', ...
        bayes_parm_editor(data.main_obj, 'get_a0_act_auto'));
    H = update_a0_act_mode(H);

    % Prior and VB estimation parameters
    set(H.a0_edit, 'String', num2str(bayes_parm.a0));
    set(H.a0_act_edit, 'String', num2str(bayes_parm.a0_act));
    % set(H.Ta0_edit, 'String', num2str(bayes_parm.Ta0));
    % set(H.Ta0_act_edit, 'String', num2str(bayes_parm.Ta0_act));
    set(H.v0_edit, 'String', num2str(bayes_parm.v0));
    set(H.Tv0_edit, 'String', num2str(bayes_parm.Tv0));
    set(H.Npre_train_edit, 'String', num2str(bayes_parm.Npre_train));
    set(H.Ntrain_edit, 'String', num2str(bayes_parm.Ntrain));
    set(H.skip_edit, 'String', num2str(bayes_parm.skip));
    
    % Focal parameters
    set(H.cosval_edit, 'String', num2str(bayes_parm.cosval));
    % set(H.Rfilt_edit, 'String', num2str(bayes_parm.Rfilt));
    % set(H.reduce_edit, 'String', num2str(bayes_parm.reduce));
    % set(H.reduce_slider, 'Value', bayes_parm.reduce);
    
    % Global window parameters
    set(H.reduce_global_edit, 'String', num2str(bayes_parm.reduce_global));
    
    common = bayes_parm_editor_get_basic_gui_common(data.main_obj);
    if length(bayes_parm.basisfile_global) == 0
        % There is no parameter.
        % default is same with basic gui's basis files.
        set(H.basisfile_global_listbox, 'String', common.basis_files);
    else
        % There is parameter.
        set(H.basisfile_global_listbox, 'String', bayes_parm.basisfile_global);
    end
    
    % area_key_global
    set(H.area_key_global_popup, 'String', common.area_keys);
    area_keys = get(H.area_key_global_popup, 'String');
    idx = strmatch(bayes_parm.area_key_global, area_keys, 'exact');
    if ~isempty(idx)
        set(H.area_key_global_popup, 'Value', idx);
    else
        set(H.area_key_global_popup, 'Value', 1);
    end

    % Rfilt_global
    set(H.Rfilt_global_edit, 'String', num2str(1e3*bayes_parm.Rfilt_global));

    % Optional parameters
    if bayes_parm.cont_pr == ON
        set(H.cont_pr_on_radiobutton, 'Value', 1);
        set(H.cont_pr_off_radiobutton, 'Value', 0);
    else
        set(H.cont_pr_on_radiobutton, 'Value', 0);
        set(H.cont_pr_off_radiobutton, 'Value', 1);
    end

    if bayes_parm.soft_mode == ON
        set(H.soft_mode_on_radiobutton, 'Value', 1);
        set(H.soft_mode_off_radiobutton, 'Value', 0);
    else
        set(H.soft_mode_on_radiobutton, 'Value', 0);
        set(H.soft_mode_off_radiobutton, 'Value', 1);
    end
    
    if bayes_parm.temporal_filter == ON
        set(H.temporal_filter_on_radiobutton, 'Value', 1);
        set(H.temporal_filter_off_radiobutton, 'Value', 0);
    else
        set(H.temporal_filter_on_radiobutton, 'Value', 0);
        set(H.temporal_filter_off_radiobutton, 'Value', 1);
    end

    if bayes_parm.trial_average == ON
        set(H.trial_average_on_radiobutton, 'Value', 1);
        set(H.trial_average_off_radiobutton, 'Value', 0);
    else
        set(H.trial_average_on_radiobutton, 'Value', 0);
        set(H.trial_average_off_radiobutton, 'Value', 1);
    end

    if bayes_parm.expand_spatial_filter == ON
        set(H.expand_spatial_filter_on_radiobutton, 'Value', 1);
        set(H.expand_spatial_filter_off_radiobutton, 'Value', 0);
    else
        set(H.expand_spatial_filter_on_radiobutton, 'Value', 0);
        set(H.expand_spatial_filter_off_radiobutton, 'Value', 1);
    end

    if bayes_parm.variance_orientation == ON
        set(H.variance_orientation_on_radiobutton, 'Value', 1);
        set(H.variance_orientation_off_radiobutton, 'Value', 0);
    else
        set(H.variance_orientation_on_radiobutton, 'Value', 0);
        set(H.variance_orientation_off_radiobutton, 'Value', 1);
    end
    
    if ~isfield(bayes_parm, 'patch_norm')
        bayes_parm.patch_norm = ON;
    end
    if  bayes_parm.patch_norm == ON
        set(H.patch_size_normalization_on_radiobutton, 'Value', 1);
        set(H.patch_size_normalization_off_radiobutton, 'Value', 0);
    else
        set(H.patch_size_normalization_on_radiobutton, 'Value', 0);
        set(H.patch_size_normalization_off_radiobutton, 'Value', 1);
    end

    if ~isfield(bayes_parm, 'remove_crossed_area')
        bayes_parm.remove_crossed_area = ON;
    end
    if bayes_parm.remove_crossed_area == ON
        set(H.remove_crossed_area_on_radiobutton, 'Value', 1);
        set(H.remove_crossed_area_off_radiobutton, 'Value', 0);
    else
        set(H.remove_crossed_area_on_radiobutton, 'Value', 0);
        set(H.remove_crossed_area_off_radiobutton, 'Value', 1);
    end

    set(H.noise_reg_edit, 'String', num2str(bayes_parm.noise_reg));
    set(H.Fdmin_edit, 'String', num2str(bayes_parm.Fdmin));
    set(H.a_min_edit, 'String', num2str(bayes_parm.a_min));
    set(H.a_max_edit, 'String', num2str(bayes_parm.a_max));
    
    set(H.tan_var_edit, 'String', num2str(bayes_parm.tan_var));
    set(H.var_max_edit, 'String', num2str(bayes_parm.var_max));

function [bayes_parm, a0_act_auto] = get_gui_parms(H)
% This function gets a advanced bayes parameters from GUI.
% [IN]
%    H : structure of all object handles
% [OUT]
%    bayes_parm : bayes advanced parameters.
%    a0_act_auto: a0_act setting mode is auto or not(1 or 0)
%

    a0_act_auto = get(H.a0_act_checkbox, 'Value'); % This is not a member of bayes_parm

    % Prior and VB estimation parameters
    try
        bayes_parm.a0 = eval(get(H.a0_edit, 'String'));
        a0_act = get(H.a0_act_edit, 'String'); % a0_act is special value. [] is available.
        if isempty(a0_act)
            bayes_parm.a0_act = [];
        else
            bayes_parm.a0_act = eval(get(H.a0_act_edit, 'String'));
        end
        %bayes_parm.Ta0 = eval(get(H.Ta0_edit, 'String'));
        %bayes_parm.Ta0_act = eval(get(H.Ta0_act_edit, 'String'));
        bayes_parm.v0 = eval(get(H.v0_edit, 'String'));
        bayes_parm.Tv0 = eval(get(H.Tv0_edit, 'String'));
        bayes_parm.Ntrain = eval(get(H.Ntrain_edit, 'String'));
        bayes_parm.Npre_train = eval(get(H.Npre_train_edit, 'String'));
        bayes_parm.skip = eval(get(H.skip_edit, 'String'));
    catch
        errordlg('Please confirm Prior and VB estimation parameter.', 'error');
        rethrow(lasterror);
    end

    % Focal parameters
    %try
        %bayes_parm.Rfilt = eval(['[' get(H.Rfilt_edit, 'String') ']']);
        %bayes_parm.reduce = eval(get(H.reduce_edit, 'String'));
        %catch
        %errordlg('Please confirm Focal window parameter.', 'error');
        %rethrow(lasterror);
        %end

    % Global window
    try
        bayes_parm.reduce_global = eval(['[' get(H.reduce_global_edit, 'String') ']']);
        bayes_parm.Rfilt_global = 1e-3*eval(['[' get(H.Rfilt_global_edit, 'String') ']']);
    catch
        errordlg('Please confirm Global window parameter.', 'error');
        rethrow(lasterror);
    end
    bayes_parm.basisfile_global = get(H.basisfile_global_listbox, 'String');
    area_keys = get(H.area_key_global_popup, 'String');
    idx = get(H.area_key_global_popup, 'Value');
    if ischar(area_keys)
        bayes_parm.area_key_global = area_keys;
    else
        bayes_parm.area_key_global = area_keys{idx};
    end

    % Optional parameters
    if get(H.cont_pr_on_radiobutton, 'Value')
        bayes_parm.cont_pr = ON;
    else
        bayes_parm.cont_pr = OFF;
    end
    
    if get(H.soft_mode_on_radiobutton, 'Value')
        bayes_parm.soft_mode = ON;
    else
        bayes_parm.soft_mode = OFF;
    end

    if get(H.temporal_filter_on_radiobutton, 'Value')
        bayes_parm.temporal_filter = ON;
    else
        bayes_parm.temporal_filter = OFF;
    end

    if get(H.trial_average_on_radiobutton, 'Value');
        bayes_parm.trial_average = ON;
    else
        bayes_parm.trial_average = OFF;
    end

    if get(H.expand_spatial_filter_on_radiobutton, 'Value')
        bayes_parm.expand_spatial_filter = ON;
    else
        bayes_parm.expand_spatial_filter = OFF;
    end

    if get(H.variance_orientation_on_radiobutton, 'Value')
        bayes_parm.variance_orientation = ON;
    else
        bayes_parm.variance_orientation = OFF;
    end

    if get(H.patch_size_normalization_on_radiobutton, 'Value')
        bayes_parm.patch_norm = ON;
    else
        bayes_parm.patch_norm = OFF;    
    end
    if get(H.remove_crossed_area_on_radiobutton, 'Value')
        bayes_parm.remove_crossed_area = ON;
    else
        bayes_parm.remove_crossed_area = OFF;
    end
    
    try
        bayes_parm.noise_reg = eval(get(H.noise_reg_edit, 'String'));
        bayes_parm.Fdmin = eval(get(H.Fdmin_edit, 'String'));
        bayes_parm.cosval = eval(get(H.cosval_edit, 'String'));
        bayes_parm.a_min = eval(get(H.a_min_edit, 'String'));
        bayes_parm.a_max = eval(get(H.a_max_edit, 'String'));
    
        bayes_parm.tan_var = eval(get(H.tan_var_edit, 'String'));
        bayes_parm.var_max = eval(get(H.var_max_edit, 'String'));
    catch
        errordlg('Please confirm Optional parameter.', 'error');
        rethrow(lasterror);
    end
 
function H = update_a0_act_mode(H)
% This function changes GUI property of a0_act_edit.
% [IN]
%    H : all component handles
% [OUT]
%    H : all component handles

    if get(H.a0_act_checkbox, 'Value') == 1
        set(H.a0_act_edit, 'Enable', 'off');
    else
        set(H.a0_act_edit, 'Enable', 'on');
    end
