function [log_file, Nfail] = vb_run_batch(batch_file, log_file)
% Run batch file created by Batch file builder GUI.
% [USAGE]
%    vb_run_batch(<batch_file>[,log_file]);
% [IN]
%    batch_file : batch file created by Batch file builder GUI.
%      log_file : log file(save commandline output)
%                 if this field is empty, log_file will be 
%                 created by tempname command.
% [OUT]
%      log_file : log file name which was saved commandline output.
%         Nfail : The number of jobs which failed to execute.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Check
%
if ~exist('batch_file', 'var') || exist(batch_file, 'file') ~= 2
    error('Invalid batch_file');
end
if ~exist('log_file', 'var')
    log_file = tempname;
end

diary off;
if exist(log_file, 'file') == 2
    res = questdlg('Specified logfile already exist. What to do?', ...
                    'Confirm', 'Overwrite', 'Add', 'Cancel', ...
                    'Overwrite');
    if strcmpi(res, 'overwrite')
        delete(log_file);
    elseif strcmpi(res, 'cancel')
        disp('Batch processing was cancelled.');
        return;
    end
end

%
% --- Main Procedure
%
Nfail = 0;

                       
diary(log_file);
b = load(batch_file);

% Basic settings
proj_root = b.header.proj_root;

% Execution result will be saved to project file.
proj_file = b.header.proj_file;
set_project_filename(proj_file);

% not to stop batch processing
[verbose_level,verbose_str] = vb_get_verbose;

vb_set_verbose('WARNING');

seconds = 3;
fprintf('batch processing will start in %d seconds.\n', seconds);
for k=1:seconds
    fprintf('%d ', seconds - k+1);
    pause(1);
end
fprintf('\n');

%
% Start Batch processing
%
fprintf('=============================================================\n');
fprintf('[VBMEG] : Start batch processing (%s)\n', datestr(now));
fprintf('=============================================================\n');

Nparm_set = size(b.parm_set,1);

for k=1:Nparm_set
    parm_set = b.parm_set{k};
    Nparm = size(parm_set.list, 1);

    fprintf('Parameter set for %s\n', parm_set.set_name);
    for j=1:Nparm
try
        % Get parameter
        parm      = parm_set.list{j,1};
        parm_type = parm_set.list{j,2};

        % Get job function
        [job_func] = vb_judge_function_name(parm, parm_type);

        if strcmpi(job_func, 'unknown')
            disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
            fprintf('!!!!! Unknown parameter(type: %s) for %s - %d\n', ...
                    parm_type, parm_set.set_name, j);
            disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
            error('Unknown parameter.');
        end
 
        % Execute job
        disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
        fprintf('* %s(proj_root, parm) for %s - %d\n', job_func, parm_set.set_name, j);
        disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
        feval(job_func, proj_root, parm);
catch
    err = lasterror;
    disp(err.message);
    Nfail = Nfail + 1;
end
    end % end of loop for parameters
end % end of loop for parm set

fprintf('=============================================================\n');
fprintf('[VBMEG] : Finished processing (%s)\n', datestr(now));
fprintf('=============================================================\n');
fprintf('The number of errors = %d\n', Nfail);
diary off;

vb_set_verbose(verbose_str);
