function [evalstr, available, type_dim_str] = vb_var2evalstr(var)
% convert variable to string.
% This string can be evaluated by eval function.
% The reason why I made this function is to edit variable by editbox.
% [USAGE]
%    [evalstr, available] = vb_var2evalstr(var);
% [IN]
%    var : to be converted variable
% [OUT]
%         evalstr : converted string
%       available : =  true : you can make variable by eval() function
%                   = false : In this case, evalstr contains only type and dimension 
%                             (e.g. 'cell[5x5x5]')
%    type_dim_str : type and dimension strings(e.g. 'cell[5x5x5]')
% [NOTE]
%    unsupported case
%     - more than 3 dimensions
%     - cell array which contains except string.
%     - struct is given, just only returns 'struct'
% [HISTORY]
%    2010-12-15 rhayashi Initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('var', 'var')
    error('var is a required parameter.');
end

available = true;
evalstr   = '';
%
% --- Get information of variable
%
ret = whos('var');
dim      = length(ret.size);
dim_str  = strrep(num2str(mat2str(ret.size)), ' ', 'x'); % e.g.'[5x5x5]'
type_str = ret.class; % e.g. 'cell'
type_dim_str = [type_str, dim_str];

%
% --- convert variable to string
%
if isstruct(var)
    str = 'struct';
    available = false;
elseif dim >= 3
    % return size information e.g. [5x5x5]
    str = type_dim_str; 
    available = false;
elseif ischar(var)
    str = single_quoted_string(var);
elseif iscellstr(var)
        [L, M] = size(var);
         str = '{';
        for i=1:L
            for j=1:M
                str = [str, single_quoted_string(var{i, j})];
                if j<M
                    str = sprintf('%s,', str);
                end
            end
            if i<L
                str = sprintf('%s;\n', str);
            end
        end
        str = [str, '}'];
elseif iscell(var)
    % return type and size information
    str = type_dim_str;
    available = false;
else
    str = mat2str(var);
end
evalstr = str;

function out_str = single_quoted_string(in_str)
    out_str = sprintf('''%s''', in_str);
