function [data] = vb_parm_editor_gui_data_make(data)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%

% Processing start
accessor = cell(0);
strings  = cell(0);


% create listbox string and accessor strings
% e.g.
%   strings{1} = 'brain_parm'           :  accessor{1} = 'brain_parm'
%   strings{2} = '    .FS_left_file'    :  accessor{2} = 'brain_parm.FS_left_file';

level = 0; % depth level
top_node = '';
leaf  = data.(data.parm_name);
leaf_name = data.parm_name;

[accessor, strings] = add_node(level,...
                               top_node,...
                               leaf,...
                               leaf_name,...
                               accessor, strings, ...
                               data); 

data.accessor = accessor';
data.listbox_strings  = strings';

function [accessor, strings] = add_node(level, current_node, leaf, leaf_name, accessor, strings, data)

% indent length setting
indent = repmat('    ', 1, level);

if level == 0
    sep = '';
else
    sep = '.';
end

% enumlate settings
if isstruct(leaf)
    current_node = [current_node, sep, leaf_name];
    accessor{length(accessor)+1} = current_node;
    strings{length(strings)+1}   = [indent, sep, leaf_name];

    names = fieldnames(leaf);
    for k=1:length(names)
        [accessor, strings] = add_node(level+1, current_node, leaf.(names{k}), names{k}, accessor, strings, data);
    end
else
    
    % check parameter name includes 'file' or 'dir'
    if data.show_file_parameters && ...
       (isempty(strfind(lower(leaf_name), 'file')) && ...
        isempty(strfind(lower(leaf_name), 'dir')))
        return;
    end

    if ~isempty(data.search_name)
        % search mode
        if data.case_sensitive
            search_func = @regexp;
        else
            search_func = @regexpi;
        end

        % OR search
        hit = false;
        % search keyword from fieldname
        if ~isempty(feval(search_func, leaf_name, data.search_name, 'once'))
            hit = true; 
        end

        % search keyword from leaf value
        val = eval(['data.' current_node, sep, leaf_name]);
        if ischar(val) 
            val = {val};
        end
        if (iscellstr(val) && length(size(val))<3)
            % search char string and cell string
            ret = feval(search_func, val, data.search_name, 'once');
            for k=1:length(ret)
                if ~isempty(ret{k})
                    hit = true;
                    break;
                end
            end
        end

        % Keyword is specified but no hit.
        if hit == false, return; end
    end

    % add item to the listbox
    accessor{length(accessor)+1} = [current_node, sep, leaf_name];
    strings{length(strings)+1}   = [indent, sep, leaf_name];
end
