function [obj] = ...
    vb_batch_variable_table_set_data(obj, column_name_list, data)
% set table data
%
% [USAGE]
%     [obj] = ...
%        vb_batch_variable_table_set_data(<obj>, <column_name_list>, <data>)
% [IN]
%                 obj : vb_batch_variable_table object
%    column_name_list : column name list {1xN}
%                data : table data       {MxN}
% [OUT]
%    obj : vb_batch_variable_table object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('column_name_list', 'var')
    error('column_name_list is a required parameter.');
end
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
obj.column_name_list = column_name_list;
obj.table = data;

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
