function [obj] = vb_batch_parm_set_swap(obj, ix1, ix2)
% swap parameters
% [USAGE]
%    [obj] = vb_batch_parm_set_swap(<obj>, <ix1>, <ix2>);
% [IN]
%    obj : vb_batch_parm_set object
%    ix1 : index to be swapped
%    ix2 : index to be swapped
% [OUT]
%    obj : vb_batch_parm_set object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix1', 'var')
    error('ix1 is a required parameter.');
end
if ~exist('ix2', 'var')
    error('ix2 is a required parameter.');
end

%
% --- Main Procedure
%

tmp = obj.list(ix1, :);
obj.list(ix1, :) = obj.list(ix2, :);
obj.list(ix2, :) = tmp;

%
% --- After check
%
if nargout < 1
    error('function caller should receive vb_batch_parm_set object.');
end
